//--------------------------------------------------------------------
// UĨACeeI
//--------------------------------------------------------------------
#ifndef __EDIT_ITEM_SELECT_H__
#define __EDIT_ITEM_SELECT_H__

#include "app/ui/UIView.h"
#include "app/ui/UITouchBarView.h"
#include "app/ui/UITouchBarListener.h"
#include "app/tool/app_tool_TouchPanelOperator.h"


GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

class EditScene;
class EditItemSelectScroller;

class EditItemSelect : public app::ui::UIView, public app::ui::UITouchBarListener
{
public:
  enum ViewMode
  {
    MODE_2SCROLL, // 2EXN[
    MODE_1x2FIX,  // I2EŒ
    MODE_SCROLL,  // 1EXN[
    MODE_2x3FIX,  // 23s̑I6REŒ
  };
  
  enum Result
  {
    RESULT_NONE,
    RESULT_EXIT,
  };
  
  enum State
  {
    CATEGORY_NONE = -1,

    STATE_BG = 0,
    STATE_POSE,
    STATE_FACE,
    STATE_BGM,
    STATE_SE,

    STATE_MODEL,
    STATE_EFFECT,
    STATE_CAMERA,
    STATE_TELOP,
    //STATE_DELETE, // ɂ͂Ȃ
    
      STATE_BLIGHTNESS_SELECT,
      STATE_BG_SELECT,
    
      STATE_TELOP_TEXT_SELECT,
      STATE_TELOP_MOVE_SELECT,
    
      STATE_MOTION_SELECT,
      STATE_ROTATION_SELECT,
    
      STATE_EYE_SELECT,
      STATE_MOUTH_SELECT,
  };
public:
  EditItemSelect( Main* main, EditScene* owner, app::util::Heap * heap, gfl::grp::g2d::LytSys* layout, gfl::ui::DeviceManager* device, int second);
  ~EditItemSelect();
  
  // RgN^ɌĂł
  void ChangeCategory(Category category);
  
  virtual void Draw();
  virtual void Update();
  
  Main* GetMain(){return m_main;}
  
  virtual bool OnSelectedButton(u32 buttonID);
  Result GetResult(){return m_result;}
  
  app::util::G2DUtil* GetLayout(){return m_g2dUtil;}
  app::util::Heap* GetHeap(){return m_heap;}
  gfl::ui::Button* GetButton(){return m_device->GetButton(0);}
  gfl::ui::TouchPanel* GetTouchPanel(){return m_device->GetTouchPanel(0);}
  
  // Ajԍ̎擾
  int GetAnimeID(ViewMode mode, int button_index, int anime_index);
  int GetPaneID(ViewMode mode, int button_index);
  int GetTextPaneID(ViewMode mode, int button_index);
  int GetCheckPaneID(ViewMode mode, int button_index);
  int GetNewPaneID(ViewMode mode, int button_index);
  
  // J[\ʒũZbg
  void SetCursorPos(int pane_id);
  
  // StateɉāAvr[v
  void RequirePreview(int id);
  
private:
  // \[h؂ւ
  void ChangeMode(ViewMode mode);
  
  // ̃JeSɕύX
  void ChangeNextCategory(State category, int m_cursor_pos);
  
  
private:
  // CAEg̍쐬
  void CreateLayout(  gfl::grp::g2d::LytSys* layout );
  // CAEg̍폜
  void DeleteLayout();
  
  // bZ[WEBhE̍쐬
  void CreateMessageWindow();
  void DeleteMessageWindow();
  
  // ʂɉāAR[hҏW
  void ChangeRecord(State state, int id);
  
private:
  Main* m_main;
  EditScene* m_owner;
  int m_second;
  gfl::ui::DeviceManager* m_device;
  app::util::Heap* m_heap;
  
  bool m_is_poke;
  
  // ^b`͗p
  app::tool::TouchPanelOperator* m_touchpanel;
  
  State m_state;
  
  // XN[p
  EditItemSelectScroller* m_scroll;
  
  // ʎ擾p
  Result m_result;
  
  // J[\\
  app::tool::MenuCursor* m_cursor;
  int m_cursor_pos;
  
  // ^b`o[
  app::ui::UITouchBarView* m_touch;
  
public:  
  // Aj`
  enum
  {
    ANIM_DUMMY_ACTIVE,
    ANIM_DUMMY_CANCEL,
    ANIM_DUMMY_PASSIVE,
    ANIM_DUMMY_RELEASE,
    ANIM_DUMMY_HOLD,
    ANIM_DUMMY_TOUCH,
    
    ANIM_2SCROLL_OFF,
    ANIM_2SCROLL_ON,
    ANIM_1x2FIX_OFF,
    ANIM_1x2FIX_ON,
    ANIM_SCROLL_OFF,
    ANIM_SCROLL_ON,
    ANIM_2x3FIX_OFF,
    ANIM_2x3FIX_ON,
    
    ANIM_ACTIVE,
    ANIM_CANCEL,
    ANIM_PASSIVE,
    ANIM_RELEASE,
    ANIM_HOLD,
    ANIM_TOUCH,
  };
};


GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

#endif //__EDIT_ITEM_SELECT_H__
