
#include "EditItemSelect.h"
#include "EditItemSelectScroller.h"
#include "EditScene.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(promotion)

static const int PANE_START_INDEX[] = {
  0,
  12,
  12 + 2,
  12 + 2 + 6
};
static const int BUTTON_PANE[] = 
{
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_02,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_03,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_04,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_05,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_06,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_07,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_08,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_09,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_10,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_11,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_WINDOW_12,
  
  PANENAME_P_VIDEO02_LOWER_PANE_P2_WINDOW_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P2_WINDOW_02,
  
  PANENAME_P_VIDEO02_LOWER_PANE_P3_WINDOW_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_WINDOW_02,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_WINDOW_03,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_WINDOW_04,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_WINDOW_05,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_WINDOW_06,
  
  PANENAME_P_VIDEO02_LOWER_PANE_P4_WINDOW_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_WINDOW_02,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_WINDOW_03,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_WINDOW_04,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_WINDOW_05,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_WINDOW_06,
};

static const int BUTTON_TEXT_PANE[] = 
{
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_02,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_03,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_04,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_05,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_06,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_07,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_08,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_09,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_10,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_11,
  PANENAME_P_VIDEO02_LOWER_PANE_P1_TEXT_12,
  
  PANENAME_P_VIDEO02_LOWER_PANE_P2_TEXT_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P2_TEXT_02,
  
  PANENAME_P_VIDEO02_LOWER_PANE_P3_TEXT_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_TEXT_02,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_TEXT_03,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_TEXT_04,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_TEXT_05,
  PANENAME_P_VIDEO02_LOWER_PANE_P3_TEXT_06,
  
  PANENAME_P_VIDEO02_LOWER_PANE_P4_TEXT_01,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_TEXT_02,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_TEXT_03,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_TEXT_04,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_TEXT_05,
  PANENAME_P_VIDEO02_LOWER_PANE_P4_TEXT_06,
};

static const int BUTTON_CHECK_PANE[] = {
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_01,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_02,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_03,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_04,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_05,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_06,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_07,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_08,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_09,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_10,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_11,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK1_12,
  
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK2_01,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK2_02,
  
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK3_01,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK3_02,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK3_03,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK3_04,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK3_05,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK3_06,
  
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK4_01,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK4_02,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK4_03,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK4_04,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK4_05,
  PANENAME_P_VIDEO02_LOWER_PANE_CHECK4_06,
};

static const int BUTTON_NEW_PANE[] = 
{
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_01,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_02,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_05,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_06,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_07,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_08,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_09,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_10,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_11,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_12,
  
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_02_01,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_02_02,
  
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03_01,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03_02,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03_03,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03_04,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03_05,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_03_06,
  
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04_01,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04_02,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04_03,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04_04,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04_05,
  PANENAME_P_VIDEO02_LOWER_PANE_NEW_04_06,
};

//------------------------------------------------------------------------------
// con, des
//------------------------------------------------------------------------------
EditItemSelect::EditItemSelect( Main* main, EditScene* owner, app::util::Heap * heap, gfl::grp::g2d::LytSys* layout, gfl::ui::DeviceManager* device, int second )
 : 
app::ui::UIView(heap),
m_main(main),
m_owner(owner),
m_second(second),
m_device(device),
m_heap(heap),
m_result(RESULT_NONE)
{
  gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
  m_graphicSystem = gm->GetGraphicsSystem();
  
  // CAEg{̂̍쐬
  this->CreateLayout(layout);
  
  // XN[[̍쐬
  m_scroll = GFL_NEW(m_heap->pHeap) EditItemSelectScroller(this);
  
  // ^b`͋@\̍쐬
  m_touchpanel = GFL_NEW(m_heap->pHeap) app::tool::TouchPanelOperator(this->GetTouchPanel(), gamesystem::FRAMEMODE_30);
  
  
  // |P\ۂmF
  m_is_poke = false; int model = -1;
  for(int i = 0; i <= m_second; ++i)
  {
    if(m_main->GetRecord()[i].model.model != -1){model = m_main->GetRecord()[i].model.model;}
  }
  if(model != -1 && model == 0){m_is_poke = true;}
}

EditItemSelect::~EditItemSelect()
{
  GFL_DELETE m_scroll;
  this->DeleteLayout();
}

//------------------------------------------------------------------------------
// ^b`o[̔
//------------------------------------------------------------------------------
bool EditItemSelect::OnSelectedButton(u32 button)
{
  switch(button)
  {
  case app::ui::UITouchBarView::BUTTON_ID_RETURN:
    m_owner->Play();
    m_result = RESULT_EXIT;
    break;
    
  // @todo UITouchBarViewRewind{^̒ǉ҂
  //case app::ui::UITouchBarView::BUTTON_REWIND:
  case app::ui::UITouchBarView::BUTTON_ID_SEARCH:
    break;
  }
  
  return false;
}
//------------------------------------------------------------------------------
// UpdateEDraw
//------------------------------------------------------------------------------
void EditItemSelect::Update()
{
  UIView::Update();
  m_cursor->Update();
  m_touchpanel->Update();
  
  switch(m_state)
  {
  case STATE_BG:
  case STATE_POSE:
  case STATE_FACE:
  case STATE_MODEL:
  case STATE_TELOP:
    // ^b`
    if(m_touchpanel->IsDecide())
    {
      gfl::math::VEC2 v;m_touchpanel->GetDecideValue(&v);
      if(m_g2dUtil->GetHitPane(0, this->GetPaneID(MODE_1x2FIX, 0), v.x, v.y, false))
      {
        this->SetCursorPos(this->GetPaneID(MODE_1x2FIX, 0));
        m_cursor_pos = 0;
        this->ChangeNextCategory(m_state, m_cursor_pos);
      }
      else
      if(m_g2dUtil->GetHitPane(0, this->GetPaneID(MODE_1x2FIX, 1), v.x, v.y, false))
      {
        this->SetCursorPos(this->GetPaneID(MODE_1x2FIX, 1));
        m_cursor_pos = 1;
        this->ChangeNextCategory(m_state, m_cursor_pos);
      }
      
    }
    else
    if(m_touchpanel->IsDrag())
    {
      gfl::math::VEC2 v;m_touchpanel->GetDragStartValue(&v);
      if(m_g2dUtil->GetHitPane(0, this->GetPaneID(MODE_1x2FIX, 0), v.x, v.y, false))
      {
        this->SetCursorPos(this->GetPaneID(MODE_1x2FIX, 0));
        m_cursor_pos = 0;
      }
      else
      if(m_g2dUtil->GetHitPane(0, this->GetPaneID(MODE_1x2FIX, 1), v.x, v.y, false))
      {
        this->SetCursorPos(this->GetPaneID(MODE_1x2FIX, 1));
        m_cursor_pos = 1;
      }
    }
    
    // L[
    if(this->GetButton()->IsTrigger(gfl::ui::BUTTON_UP))
    {
      this->SetCursorPos(this->GetPaneID(MODE_1x2FIX, 0));
      m_cursor_pos = 0;
    }
    else
    if(this->GetButton()->IsTrigger(gfl::ui::BUTTON_DOWN))
    {
      this->SetCursorPos(this->GetPaneID(MODE_1x2FIX, 1));
      m_cursor_pos = 1;
    }
    
    // 肳ꂽ
    if(this->GetButton()->IsTrigger(gfl::ui::BUTTON_A))
    {
      this->ChangeNextCategory(m_state, m_cursor_pos);
    }
    break;
    
  case STATE_BGM:
  case STATE_SE:
  case STATE_EFFECT:
  case STATE_CAMERA:
    {
      m_scroll->Update();
      
      // ʂɉāAR[hҏW
      EditItemSelectScroller::Result ret = m_scroll->GetResult();
      if(ret >= EditItemSelectScroller::RESULT_DECIDE)
      {
        this->ChangeRecord(m_state, ret);
      }
    }
    break;
    
  case STATE_BLIGHTNESS_SELECT:
  case STATE_BG_SELECT:
  case STATE_TELOP_TEXT_SELECT:
  case STATE_TELOP_MOVE_SELECT:
  case STATE_MOTION_SELECT:
  case STATE_ROTATION_SELECT:
  case STATE_EYE_SELECT:
  case STATE_MOUTH_SELECT:
    {
      m_scroll->Update();
      
      // ʂɉāAR[hҏW
      EditItemSelectScroller::Result ret = m_scroll->GetResult();
      if(ret >= EditItemSelectScroller::RESULT_DECIDE)
      {
        this->ChangeRecord(m_state, ret);
      }
    }
    break;
  }
  
  m_touch->Update();
}

void EditItemSelect::Draw()
{
  m_g2dUtil->Draw2D(m_graphicSystem, 0);
  m_cursor->Draw(m_graphicSystem, gfl::grp::DISPLAY_LOWER);
  m_touch->Draw();
}
//------------------------------------------------------------------------------
// CAEg̍쐬E폜
//------------------------------------------------------------------------------
void EditItemSelect::CreateLayout(gfl::grp::g2d::LytSys* layout)
{
  static const app::util::G2DUtil::LYT_RES_DATA tbl[] = {
    { ARCID_PROMOTION,         0, LYTRES_MSG_WINDOW_RES_END, app::util::G2DUtil::ATTACH_ROOT },
    { ARCID_COMMON_MSGWINDOW,  0,                         0, app::util::G2DUtil::ATTACH_RESOURCE  }, // 01: ʃ\[X: bZ[WEBhE
  };
  static const gfl::grp::g2d::LytArcIndex anim[] = {
    LYTRES_LAYOUT_P_VIDEO02_LOWER_ACTIVE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_CANSEL_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_PASSIVE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_RELEASE_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_TOUCH_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_TOUCH_RELEASE_BCLAN,
    
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P1_POS_OFF_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P1_POS_ON_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P2_POS_OFF_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P2_POS_ON_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P3_POS_OFF_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P3_POS_ON_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P4_POS_OFF_BCLAN,
    LYTRES_LAYOUT_P_VIDEO02_LOWER_P4_POS_ON_BCLAN,
  };
  static const app::util::G2DUtil::LYTWK_DATA data[] = {
    {
      0,
      LYTRES_LAYOUT_P_VIDEO02_LOWER_BCLYT,
      anim,
      GFL_NELEMS(anim),
      GFL_NELEMS(anim) + 26 * 6,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true, // \ݒ
    },
  };
  
  this->Create2D(
    m_heap,
    layout,
    GFL_NELEMS(data),
    tbl,
    GFL_NELEMS(tbl),
    data, GFL_NELEMS(data),
    GARC_message_promo_video_system_DAT
  );
  /*
  // LAj̐ݒ
  app::util::LytUtil::ShareAnimeDesc desc[26*6];
  for(int i = 0; i < 26; ++i)
  {
    for(int j = 0; j < 6; ++j)
    {
      int index = j + i*6;
      desc[index].start_anime_index = ANIM_ACTIVE + index;
      desc[index].max_share_num = 1;
      desc[index].anime_data = j;
      desc[index].share_group_index = PANENAME_P_VIDEO02_LOWER_GROUP_BUTTON_ANIME;
      desc[index].share_pane_index = BUTTON_PANE[i];
    }
  }
  
  m_g2dUtil->CreateShareAnime(0, desc, GFL_NELEMS(desc));
  */
  
  // ^b`o[
  {
    // @todo ^b`o[r[Ɋ߂{^߁ABUTON_SEARCHgpĂ̂ŁA㍷ւ
    static const app::ui::UITouchBarView::SETUP touch_setup[] = {
      {app::ui::UITouchBarView::BUTTON_ID_RETURN, PANENAME_P_VIDEO02_LOWER_PANE_RETURN_ICON_POS},
      {app::ui::UITouchBarView::BUTTON_ID_SEARCH, PANENAME_P_VIDEO02_LOWER_PANE_REWIND_ICON_POS},
    };
    
    m_touch = GFL_NEW(m_heap->pHeap) app::ui::UITouchBarView(
      m_heap,
      this->GetGraphicSystem(),
      layout,
      this->GetLayoutWork(0),
      touch_setup,
      GFL_NELEMS(touch_setup)
    );
    
    m_touch->SetListener(this);
  }
  
  // J[\̍쐬
  if(m_cursor == NULL)
  {
    m_cursor = GFL_NEW(m_heap->pHeap) app::tool::MenuCursor(m_g2dUtil->GetLayoutSystem());
    m_cursor->LoadLayoutResource(m_heap->pHeap, m_heap->pDevHeapAllocator);
    static const gfl::grp::g2d::LytWkSetUp CURSOR_SETUP = {
      gfl::math::VEC3( 0, -290, 0 ), // pos
      gfl::math::VEC2( 1, 1 ), // scale
      gfl::math::VEC3( 0, 0, 0 ), // rotate
      1, // priority
    };
    m_cursor->CreateLayoutWork(&CURSOR_SETUP, false);
    m_cursor->StartAnime(gamesystem::FRAMEMODE_30);
    // [h̕ύXs܂ŁA\ɂĂ
    m_cursor->SetVisible(false);
  }
}
void EditItemSelect::DeleteLayout()
{
  // J[\̍폜
  if(m_cursor)
  {
    m_cursor->DeleteLayoutWork();
    m_cursor->ReleaseLayoutResource();
    GFL_DELETE(m_cursor);
    m_cursor = NULL;
  }
  
  // ^b`o[
  GFL_DELETE m_touch;
  // {̂
  this->Delete2D();
}

//------------------------------------------------------------------------------
// JeS̕ύX
//------------------------------------------------------------------------------
void EditItemSelect::ChangeCategory(Category category)
{
  m_state = (State)category;
  Record& rec = m_main->GetRecord()[m_second];
  switch(category)
  {
  case CATEGORY_BG:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make09);
    // 邳E͂
    this->ChangeMode(MODE_1x2FIX);
    // 邳
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 0), pvd_make10);
    // ͂I
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 1), pvd_make19);
    
    // check
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 0),(rec.background.blightness != -1));
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 1),(rec.background.bg != -1));
    break;
  case CATEGORY_POSE:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make94);
    // |[YIԁEI
    this->ChangeMode(MODE_1x2FIX);
    // I
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 0), pvd_make95);
    // |[YI
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 1), pvd_make102);
    
    // check
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 0),(rec.model.rotation != -1));
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 1),(rec.model.motion != -1));
    break;
  case CATEGORY_FACE:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make172);
    // \
    this->ChangeMode(MODE_1x2FIX);
    // 
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 0), pvd_make173);
    // 
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 1), pvd_make182);
    
    // check
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 0),(rec.model.eye != -1));
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 1),(rec.model.mouth != -1));
    break;
  case CATEGORY_BGM:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make30);
    this->ChangeMode(MODE_2SCROLL);
    m_scroll->Initialize(MODE_2SCROLL, rec.bgm);
    for(int i = 0; i < GFL_NELEMS(PROMO_DATA_BGM); ++i)
      m_scroll->Add(i, PROMO_DATA_BGM[i].msg);
    m_scroll->Create();
    break;
  case CATEGORY_SE:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make63);
    this->ChangeMode(MODE_2SCROLL);
    this->Update();
    m_scroll->Initialize(MODE_2SCROLL, rec.se);
    for(int i = 0; i < GFL_NELEMS(PROMO_DATA_SE); ++i)
      m_scroll->Add(i, PROMO_DATA_SE[i].msg);
    m_scroll->Create();
    break;
  
  case CATEGORY_MODEL:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make200);
    {
      // sJ`EoAGɖ߂
      this->ChangeMode(MODE_1x2FIX);
      // |Po @todo |P̃Zbg
      m_g2dUtil->SetRegisterMonsNameNo(0, MONSNO_PIKATYUU);
      m_g2dUtil->SetTextBoxPaneStringExpand(0, this->GetTextPaneID(MODE_1x2FIX, 0), pvd_make201);
      // Go
      gamesystem::GameManager* gameManager = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
      savedata::MyStatus*    status      = gameManager->GetGameData()->GetPlayerStatus();
      m_g2dUtil->SetRegisterPlayerName( 0, status );
      m_g2dUtil->SetTextBoxPaneStringExpand(0, this->GetTextPaneID(MODE_1x2FIX, 1), pvd_make202);
      
      // check
      m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 0),(rec.model.model == 0));
      m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 1),(rec.model.model == 1));
    }
    break;
  case CATEGORY_EFFECT:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make149);
    this->ChangeMode(MODE_2SCROLL);
    m_scroll->Initialize(MODE_2SCROLL, rec.particle);
    for(int i = 0; i < GFL_NELEMS(PROMO_DATA_EFFECT); ++i)
      m_scroll->Add(i, PROMO_DATA_EFFECT[i].msg);
    m_scroll->Create();
    break;
  case CATEGORY_CAMERA:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make204);
    this->ChangeMode(MODE_SCROLL);
    m_scroll->Initialize(MODE_SCROLL, rec.camera);
    if(m_is_poke)
    {
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_CAMERA_POKE); ++i)
        m_scroll->Add(i, PROMO_DATA_CAMERA_POKE[i].msg);
    }
    else
    {
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_CAMERA); ++i)
        m_scroll->Add(i, PROMO_DATA_CAMERA[i].msg);
    }
    m_scroll->Create();
    break;
  case CATEGORY_TELOP:
    m_g2dUtil->SetTextBoxPaneString(0, PANENAME_P_VIDEO02_LOWER_PANE_TOP_TEXT, pvd_make224);
    // ebvIԁEI
    this->ChangeMode(MODE_1x2FIX);
    
    // ebvI
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 0), pvd_make225);
    // I
    m_g2dUtil->SetTextBoxPaneString(0, this->GetTextPaneID(MODE_1x2FIX, 1), pvd_make226);
    
    // check
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 0),(rec.telop[0].effect != -1));
    m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 1),(rec.telop[0].text != -1));
    break;
  case CATEGORY_DELETE:
    // ɂ͗Ȃ͂
    break;
  }
}

//------------------------------------------------------------------------------
// ̃JeSɕύX
//------------------------------------------------------------------------------
void EditItemSelect::ChangeNextCategory(State category, int cursor)
{
  m_cursor->SetVisible(false);
  Record& rec = m_main->GetRecord()[m_second];
  switch(category)
  {
  case STATE_BG:
    if(!cursor)
    {
      //  邳ς
      this->ChangeMode(MODE_SCROLL);
      m_scroll->Initialize(MODE_SCROLL, rec.background.blightness);
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_BLIGHTNESS); ++i)
        m_scroll->Add(i, PROMO_DATA_BLIGHTNESS[i].msg);
      m_scroll->Create();
      
      m_state = STATE_BLIGHTNESS_SELECT;
    }
    else
    {
      //  wiI
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.background.bg);
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_BG); ++i)
        m_scroll->Add(i, PROMO_DATA_BG[i].msg);
      m_scroll->Create();
      
      m_state = STATE_BG_SELECT;
    }
    break;
    
  case STATE_POSE:
    if(!cursor)
    {
      //  I
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.model.rotation);
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_ROTATION); ++i)
        m_scroll->Add(i, PROMO_DATA_ROTATION[i].msg);
      m_scroll->Create();
      
      m_state = STATE_ROTATION_SELECT;
    }
    else
    {
      //  |[YI
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.model.motion);
      // |P\ǂŏꍇ
      if(m_is_poke)
      {
          for(int i = 0; i < GFL_NELEMS(PROMO_DATA_MOTION_POKE); ++i)
            m_scroll->Add(i, PROMO_DATA_MOTION_POKE[i].msg);
      }
      else
      {
        if(m_main->IsFemale())
        {
          for(int i = 0; i < GFL_NELEMS(PROMO_DATA_MOTION_FEMALE); ++i)
            m_scroll->Add(i, PROMO_DATA_MOTION_FEMALE[i].msg);
        }
        else
        {
          for(int i = 0; i < GFL_NELEMS(PROMO_DATA_MOTION_MALE); ++i)
            m_scroll->Add(i, PROMO_DATA_MOTION_MALE[i].msg);
        }
      }
      m_scroll->Create();
      
      m_state = STATE_MOTION_SELECT;
    }
    break;
    
  case STATE_FACE:
    if(!cursor)
    {
      //  
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.model.eye);
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_EYE); ++i)
        m_scroll->Add(i, PROMO_DATA_EYE[i].msg);
      m_scroll->Create();
      
      m_state = STATE_EYE_SELECT;
    }
    else
    {
      //  
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.model.mouth);
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_MOUTH); ++i)
        m_scroll->Add(i, PROMO_DATA_MOUTH[i].msg);
      m_scroll->Create();
      
      m_state = STATE_MOUTH_SELECT;
    }
    break;
    
  case STATE_TELOP:
    if(!cursor)
    {
      //  I
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.telop[0].effect);
      for(int i = 0; i < GFL_NELEMS(PROMO_DATA_TELOP); ++i)
        m_scroll->Add(i, PROMO_DATA_TELOP[i].msg);
      m_scroll->Create();
      
      m_state = STATE_TELOP_MOVE_SELECT;
    }
    else
    {
      //  ebvI
      this->ChangeMode(MODE_2SCROLL);
      m_scroll->Initialize(MODE_2SCROLL, rec.telop[0].text);
      if(m_main->IsFemale())
      {
        for(int i = 0; i < GFL_NELEMS(PROMO_DATA_TELOP_TEXT_FEMALE); ++i)
          m_scroll->AddTelop(i, PROMO_DATA_TELOP_TEXT_FEMALE[i].msg);
      }
      else
      {
        for(int i = 0; i < GFL_NELEMS(PROMO_DATA_TELOP_TEXT_MALE); ++i)
          m_scroll->AddTelop(i, PROMO_DATA_TELOP_TEXT_MALE[i].msg);
      }
      m_scroll->Create();
      
      m_state = STATE_TELOP_TEXT_SELECT;
    }
    break;
    
  case STATE_MODEL:
    // |PfEvC[f̐؂ւ
    // ł͎̃JeSɍsɁAfύX
    {
      this->ChangeRecord(m_state, m_cursor_pos);
      this->RequirePreview(m_cursor_pos);
      m_cursor->SetVisible(true);
      // check
      m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 0),(m_cursor_pos == 0));
      m_g2dUtil->SetPaneVisible(0, this->GetCheckPaneID(MODE_1x2FIX, 1),(m_cursor_pos == 1));
    }
    break;
  }
}

//------------------------------------------------------------------------------
// ڂ̕ύX
//------------------------------------------------------------------------------
void EditItemSelect::ChangeMode(ViewMode mode)
{
  m_g2dUtil->StopAnime(0, ANIM_SCROLL_ON);
  m_g2dUtil->StopAnime(0, ANIM_2SCROLL_ON);
  m_g2dUtil->StopAnime(0, ANIM_1x2FIX_ON);
  m_g2dUtil->StopAnime(0, ANIM_2x3FIX_ON);
  
  m_g2dUtil->StartAnime(0, ANIM_SCROLL_OFF);
  m_g2dUtil->StartAnime(0, ANIM_2SCROLL_OFF);
  m_g2dUtil->StartAnime(0, ANIM_1x2FIX_OFF);
  m_g2dUtil->StartAnime(0, ANIM_2x3FIX_OFF);
  
  switch(mode)
  {
  case MODE_2SCROLL:
    m_g2dUtil->StartAnime(0, ANIM_2SCROLL_ON);
    break;
  case MODE_1x2FIX:
    m_g2dUtil->StartAnime(0, ANIM_1x2FIX_ON);
    break;
  case MODE_SCROLL:
    m_g2dUtil->StartAnime(0, ANIM_SCROLL_ON);
    break;
  case MODE_2x3FIX:
    m_g2dUtil->StartAnime(0, ANIM_2x3FIX_ON);
    break;
  };
  
  // @todo łƂ肠NewACRSĂ
  for(int i = 0; i < GFL_NELEMS(BUTTON_NEW_PANE); ++i)
    m_g2dUtil->SetPaneVisible(0, BUTTON_NEW_PANE[i], false);
    
  // J[\ʒu
  UIView::Update();
  this->SetCursorPos(this->GetPaneID(mode, 0));
  m_cursor_pos = 0;
}

//------------------------------------------------------------------------------
// Ajԍ̎擾
//------------------------------------------------------------------------------
int EditItemSelect::GetAnimeID(ViewMode mode, int button_index, int anime_index)
{
  return (PANE_START_INDEX[mode] + button_index) * 6 + anime_index;
}
int EditItemSelect::GetPaneID(ViewMode mode, int button_index)
{
  return BUTTON_PANE[PANE_START_INDEX[mode] + button_index];
}
int EditItemSelect::GetTextPaneID(ViewMode mode, int button_index)
{
  return BUTTON_TEXT_PANE[PANE_START_INDEX[mode] + button_index];
}
int EditItemSelect::GetCheckPaneID(ViewMode mode, int button_index)
{
  return BUTTON_CHECK_PANE[PANE_START_INDEX[mode] + button_index];
}
int EditItemSelect::GetNewPaneID(ViewMode mode, int button_index)
{
  return BUTTON_NEW_PANE[PANE_START_INDEX[mode] + button_index];
}

//------------------------------------------------------------------------------
// J[\ʒũZbg
//------------------------------------------------------------------------------
void EditItemSelect::SetCursorPos(int pane_index)
{
  m_cursor->SetVisible(true);
  m_cursor->Put(m_g2dUtil->GetLayoutWork(0), pane_index);
}

//------------------------------------------------------------------------------
// ʂɉāAR[hҏW
//------------------------------------------------------------------------------
void EditItemSelect::ChangeRecord(State state, int id)
{
  Record& rec = m_main->GetRecord()[m_second];
  switch(state)
  {
  case STATE_BGM:
    rec.bgm = id;
    break;
  case STATE_SE:
    rec.se = id;
    break;
  case STATE_EFFECT:
    rec.particle = id;
    break;
  case STATE_CAMERA:
    rec.camera = id;
    break;
    
  case STATE_MODEL:
    rec.model.model = id;
    rec.camera = 0;
    rec.model.motion = 0;
    // fύXꂽ̂ŁA̔JE|[Y𒲐
    for(int i = m_second+1; i < RECORD_SIZE; ++i)
    {
      if(m_main->GetRecord()[i].model.model == id){break;}
      if(m_main->GetRecord()[i].camera  != -1){m_main->GetRecord()[i].camera = 0;}
      if(m_main->GetRecord()[i].model.motion  != -1){m_main->GetRecord()[i].model.motion = 0;}
    }
    
    m_is_poke = (id == 0);
    break;
    
  case STATE_BLIGHTNESS_SELECT:
    rec.background.blightness = id;
    break;
  case STATE_BG_SELECT:
    rec.background.bg = id;
    break;
  case STATE_TELOP_TEXT_SELECT:
    rec.telop[0].text = id;
    break;
  case STATE_TELOP_MOVE_SELECT:
    rec.telop[0].effect = id;
    break;
  case STATE_MOTION_SELECT:
    rec.model.motion = id;
    break;
  case STATE_ROTATION_SELECT:
    rec.model.rotation = id;
    break;
  case STATE_EYE_SELECT:
    rec.model.eye = id;
    break;
  case STATE_MOUTH_SELECT:
    rec.model.mouth = id;
    break;
  }
}

//------------------------------------------------------------------------------
// m_stateɉāApreviewv @todo
//------------------------------------------------------------------------------
void EditItemSelect::RequirePreview(int id)
{
  Record rec;
  rec.background.bg = 0;
  rec.background.blightness = 4;
  rec.model.model = (m_is_poke != true);
  rec.model.motion = 0;
  rec.model.rotation = 0;
  rec.model.eye = 0;
  rec.model.mouth = 0;
  rec.telop[0].text = -1;
  rec.telop[0].effect = -1;
  rec.bgm = -1;
  rec.se = -1;
  rec.camera = 0;
  rec.particle = -1;
  
  switch(m_state)
  {
  case STATE_BGM:
    rec.bgm = id;
    break;
  case STATE_SE:
    rec.se = id;
    break;
  case STATE_EFFECT:
    rec.particle = id;
    break;
  case STATE_CAMERA:
    rec.camera = id;
    break;
  
  case STATE_MODEL:
    rec.model.model = id;
    break;
    
  case STATE_BLIGHTNESS_SELECT:
    rec.background.blightness = id;
    break;
  case STATE_BG_SELECT:
    rec.background.bg = id;
    rec.background.blightness = 0;
    break;
  case STATE_TELOP_TEXT_SELECT:
    rec.telop[0].text = id;
    rec.telop[0].effect = 0;
    break;
  case STATE_TELOP_MOVE_SELECT:
    rec.telop[0].text = 1;
    rec.telop[0].effect = id;
    break;
  case STATE_MOTION_SELECT:
    rec.model.motion = id;
    break;
  case STATE_ROTATION_SELECT:
    rec.model.rotation = id;
    break;
  case STATE_EYE_SELECT:
    rec.model.eye = id;
    break;
  case STATE_MOUTH_SELECT:
    rec.model.mouth = id;
    break;
  }
  
  m_owner->Preview(rec, false);
}

GFL_NAMESPACE_END(promotion)
GFL_NAMESPACE_END(app)

