#! ruby -Ks
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		pokemon_memory_converter.rb
#	@brief  |P̋LRo[^
#	@author	Toru=Nagihashi
#	@date		2012.08.03
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
require "conv_tool.rb"
require "../../tools/headerdata.rb"

#-------------------------------------
# 
#=====================================
BODYCSVNAME   = ARGV[0]
HEADERCSVNAME = ARGV[1]
MSTXTNAME     = ARGV[2]
OUTPUTNAME    = ARGV[3]

#=============================================================================
#
#   W[
#
#=============================================================================
#-------------------------------------
# definef[^Ro[g
#=====================================
def  convertDefine( defCsv, hash, header )

  makeDefine( defCsv, "DataType", "DATA_TYPE", hash, header )

end

#-------------------------------------
# #start, pgname, jpname
# ̕\f[^nbVƃwb_ɏ
#=====================================
DEF_ROW_START       = 1         #sJnʒu
DEF_COL_PG_NAME     = 1         #:`
DEF_COL_JP_NAME     = 2         #:͖
def makeDefine( csv, enum_name, header_prefix, hash, header )
  
  header.write( "enum #{enum_name} {\n" )
  
  cnt = 0
  for row in DEF_ROW_START...csv.row_length-1
    
    pg_name  = csv.get( row, DEF_COL_PG_NAME )
    jp_name  = csv.get( row, DEF_COL_JP_NAME )

    header.write( "\t#{header_prefix}_#{pg_name} = #{cnt.to_i},// #{jp_name}\n" )
    hash.store( jp_name, cnt.to_i )
    
    cnt = cnt + 1
  end
  
  header.write( "\t#{header_prefix}_MAX = #{cnt.to_i},\n" )
  
  header.write( "};\n" )
end

#-------------------------------------
# BodyRo[g
#=====================================

BODY_FEEL_NUM           = 24    #C̐
BODY_FEEL_ARRAY         = 4

BODY_ROW_START          = 3     #s:Jnʒu
BODY_COL_TAG            = 1     #:^O
BODY_COL_LEVEL          = 2     #:x
BODY_COL_CODE           = 3     #:R[h
BODY_COL_PERCENT        = 4     #:m
BODY_COL_MESSAGE        = 5     #:bZ[W
BODY_COL_DATATYPE       = 6     #:f[^^Cv
BODY_COL_FEEL_START     = 7     #:C
BODY_COL_FEEL_END       = BODY_COL_FEEL_START + BODY_FEEL_NUM    #:C

def convertBody( csv, cdat, hash, txt, header )
 
  cdat.write( "static const struct {\n" )
  cdat.write( "  u32 level;\n" )
  cdat.write( "  u32 percent;\n" )
  cdat.write( "  u32 message;\n" )
  cdat.write( "  u32 data_type;\n" )
  cdat.write( "  u32 feel_bit;\n" )
  cdat.write( "} pokemon_memory_data[]  = {\n" )
  

  header.write( "enum Event {\n" )

  for row in BODY_ROW_START...csv.row_length-1
    
    tag         = csv.get( row, BODY_COL_TAG      )
    lv          = csv.get( row, BODY_COL_LEVEL    )
    code        = csv.get( row, BODY_COL_CODE     )
    percent     = csv.get( row, BODY_COL_PERCENT  )
    message     = csv.get( row, BODY_COL_MESSAGE  )
    type        = csv.get( row, BODY_COL_DATATYPE )

    header.write( "  EVENT_#{tag},\n" )
    
    cdat.write( "  {//EVENT_#{tag} \n" )
    cdat.write( "    #{lv},\n" )
    cdat.write( "    #{percent},\n" )

    begin
      msg_no = txt.search( message.to_s, "" )
      cdat.write( "    #{msg_no},\n" )
    rescue HeaderSearchError
      puts "bZ[W݂܂ #{message}\n"
      exit(1)
    end
 
    cdat.write( "    #{getHash(hash,type.to_s)},\n" )
    
    #C
    feel_bit = 0
    for c in BODY_COL_FEEL_START...BODY_COL_FEEL_END
      feel = csv.get( row, c)
      cnt = c - BODY_COL_FEEL_START
      if cnt >= 32 
        exit(1)
      end
      if feel.to_i == 1 
        feel_bit = feel_bit + (1 << cnt)
      end
    end
    cdat.write( "   #{feel_bit},\n" )
    
    cdat.write( "  },\n" )
  end
  
  header.write( "};\n" )
  cdat.write( "};\n" )
  
end

#-------------------------------------
# nbVl擾iexitǉj
#=====================================
def getHash( hash, key )
  if hash.key?(key) 
    return hash[key]
  end
  
  puts "#{key}݂͑܂\n"
  exit(1)
end

#=============================================================================
#
#   C
#
#=============================================================================
begin

  #csvǍ
  bodyCsv = CsvLoader.new
  bodyCsv.setPrefix( '#start' )
  bodyCsv.setSuffix( '#end' )
  bodyCsv.load( BODYCSVNAME )

  defineCsv = CsvLoader.new
  defineCsv.setPrefix( '#data_type_start' )
  defineCsv.setSuffix( '#data_type_end' )
  defineCsv.load( HEADERCSVNAME )
  
  #eLXgf[^̍쐬
  txt = HeaderDataArray.new
  txt.load( MSTXTNAME )

  #cdat쐬
  cdat    = TextBuilder.new
  cdat.write_header( "#{OUTPUTNAME}.cdat", 
                    "|P̋L̃f[^łB",
                    "Toru=Nagihashi" ) 
  
  #wb_쐬
  header    = TextBuilder.new
  header.write_header( "#{OUTPUTNAME}.h", 
                    "|P̋L̃wb_[ł",
                    "Toru=Nagihashi" ) 

  #nbV쐬
  hash  = Hash.new
  
  #Ro[g
  convertDefine( defineCsv, hash, header )
  convertBody( bodyCsv, cdat, hash, txt, header )

  #wb_
  header.genelate( "#{OUTPUTNAME}.h" )

  #cdat
  cdat.genelate( "#{OUTPUTNAME}.cdat" )

end
