### Define Persistent Variables and Functions
init -1 python:
    def TogglePersistent(variable):
        return Function(lambda: setattr(persistent, variable, not getattr(persistent, variable)))

    galleryList = [
        ["gallery/zoe sex (4).jpg", "dectomake", "[persistent.galleryname] & Zoe", "Chapter - 1"],
        ["gallery/mary charlie3 (31).jpg", "charmar1", "[persistent.sa_name] & Charlie", "Chapter - 1"],
        ["gallery/jmbar004.jpg", "zoecall", "[persistent.sa_name] & Jeremy", "Chapter - 2"],
        ["gallery/mlingsex07.jpg", "mlingsex", "Vacation 1", "Chapter - 2"],
        ["gallery/fksex06.jpg", "dinnerk", "[persistent.galleryname] & Kelly", "Chapter - 2"],
        ["gallery/zfb23.jpg", "zoebathr", "[persistent.galleryname] & Zoe", "Chapter - 2"],
        ["gallery/hondin34.jpg", "honeymoon", "Honeymoon", "Chapter - 2"],
        ["gallery/parthnext65.jpg", "parthenon2", "Swingers Club 1", "Chapter - 3"],
        ["gallery/bryceparty45.jpg", "brystr", "Bryce's Birthday", "Chapter - 3"],
        ["gallery/mfoffice25.jpg", "officesex", "[persistent.sa_name] & [persistent.galleryname]", "Chapter - 3"],
        ["gallery/lingpic15.jpg", "photoshoot", "[persistent.sa_name]'s First Shoot", "Chapter - 3"],
        ["gallery/bmgame72.jpg", "gangbang", "Gangbang", "Chapter - 3"],
        ["gallery/bryshow135.jpg", "bryceshower", "[persistent.sa_name] & Bryce", "Chapter - 4"],
        ["gallery/partint301a.jpg", "DMCHOOSE", "David & Miriam", "Chapter - 4"],
        ["gallery/bgpart00.jpg", "GBCHOOSE", "Gabriel & Bella", "Chapter - 4"],
        ["gallery/tmpart00.jpg", "TMCHOOSE", "Tyler & Mia", "Chapter - 4"],
        ["gallery/mmroom02.jpg", "davidmiriam", "The Orgy 1", "Chapter - 4"],
        ["gallery/zmshoot04.jpg", "zoephotoshoot", "Bikini Shoot", "Chapter - 4"],
        ["gallery/rachome53.jpg", "rachelcuckold", "[persistent.galleryname] & Rachel", "Chapter - 4"],
        ["gallery/fcbedroom22.jpg", "charlotte1", "[persistent.galleryname] & Charlotte", "Chapter - 4"],
        ["gallery/dicab18.jpg", "alleycab", "[persistent.sa_name] & Cabbie (NTR)", "Chapter - 4"],
        ["gallery/keymary14a.webp", "KEYMARY", "[persistent.sa_name] & Tony", "Chapter - 4"],
        ["gallery/keyblair23.webp", "BLAIRKEY", "[persistent.galleryname] & Blair", "Chapter - 4"],
        ["gallery/keyeve33.webp", "EVEKEY", "[persistent.galleryname] & Evelyn", "Chapter - 4"],
        ["gallery/keyvic64.webp", "VICKIKEY", "[persistent.galleryname] & Vicki", "Chapter - 4"],
        ["gallery/keysonya47.webp", "SONYAKEY", "[persistent.sa_name] & Sonya", "Chapter - 4"],
        ["gallery/intshop11.jpg", "shopsex", "[persistent.galleryname] & [persistent.sa_name]", "Chapter - 5"],
        ["gallery/derek20.jpg", "derekhw", "[persistent.sa_name] & Derek", "Chapter - 5"],
        ["gallery/pargis36.jpg", "giselleswing", "Giselle & Mark", "Chapter - 5"],
        ["gallery/partina25.jpg", "tinaswing", "Tina & Frank", "Chapter - 5"],
        ["gallery/parmarg46.jpg", "margaretswing", "Margaret & Carl", "Chapter - 5"],
        ["gallery/mircloset25.jpg", "mirlesb", "[persistent.sa_name] & Miriam (Lesbian)", "Chapter - 5"],
        ["gallery/marshmeet15.jpg", "marsha1", "[persistent.galleryname] & Marsha (NTR)", "Chapter - 5"],
        ["gallery/jacob21h.jpg", "jacobsex", "[persistent.sa_name] & Jacob", "Chapter - 5"],
        ["gallery/arch13.jpg", "archwaydinner", "[persistent.sa_name]", "Chapter - 5"],
        ["gallery/archsex18.jpg", "archwaysex", "[persistent.sa_name] & [persistent.galleryname]", "Chapter - 5"],
        ["gallery/tonyhome08.jpg", "tonyblairsex", "[persistent.galleryname] & Blair", "Chapter - 5"],
        ["gallery/truckstop15.jpg", "truckersex", "[persistent.sa_name] & Truckers", "Chapter - 5"],
        ["gallery/nursehotnl31.jpg", "nursehot", "[persistent.galleryname] & Friends", "Chapter - 5"],
        ["gallery/logdin26.jpg", "sexloganfred", "[persistent.sa_name] & Logan", "Chapter - 5"],
        ["gallery/johnsara05a.jpg", "consolefriend", "Sara, [persistent.galleryname], [persistent.sa_name] & Johnny", "Chapter - 5"],
        ["gallery/erliv36.jpg", "evesex", "Richard & Evelyn", "Chapter - 5"],
        ["gallery/parthvic30a.jpg", "vickiswing", "Swingers Club (Vicki)", "Chapter - 5"]
    ]

default persistent.gallerynamechange = False
default persistent.sa_namechange = False
define config.allow_underfull_grids = True

### Prompt User for Names
label galleryname:
    scene black
    if not persistent.gallerynamechange:
        $ persistent.galleryname = renpy.input("Enter your name:").strip()
        if persistent.galleryname == "":
            $ persistent.galleryname = "Fred"
        $ persistent.gallerynamechange = True
        default mc_name = persistent.galleryname
        return
    else:
        return

    if not persistent.sa_namechange:
        $ persistent.sa_name = renpy.input("Enter your wife's name:").strip()
        if persistent.sa_name == "":
            $ persistent.sa_name = "Mary"
        $ persistent.sa_namechange = True
        default sa_name = persistent.sa_name
        return
    else:
        return

label galleryrename:
    scene black
    $ persistent.galleryname = renpy.input("Enter your name:").strip()
    if persistent.galleryname == "":
        $ persistent.galleryname = "Fred"
    $ persistent.gallerynamechange = True

    $ persistent.sa_name = renpy.input("Enter your wife's name:").strip()
    if persistent.sa_name == "":
        $ persistent.sa_name = "Mary"
    $ persistent.sa_namechange = True
   
    return

### Gallery Navigation and Display
screen gallerymodnavigation():
    style_prefix "navigation"

    add "#000"  # added black color before background image so that player doesn't see the main menu when I use alpha with bg image
    add gui.main_menu_background alpha 0.1    ### background image/slideshow for gallery, alpha is transparency 0.0 is fully transparent, 1.0 is fully opaque
    text _("Scene Gallery") style "LHeading"

    textbutton _("{b}Change Name{/b}") yalign 0.95 xalign 0.95 action [ui.callsinnewcontext("galleryrename")]
    textbutton _("{b}Return{/b}")  xalign 0.05 yalign 0.95 action Return()
    textbutton _("{b}Lock/Unlock{/b}") xalign 0.50 yalign 0.95 action TogglePersistent("lock")

screen gallerymod():
    tag menu
    use gallerymodnavigation
    $ ttr = GetTooltip()
    fixed:
        xysize (1920, 750)
        vpgrid:
            cols 4
            ypos 180
            xalign 0.5
            xspacing 50
            yspacing 25
            scrollbars "vertical"
            side_spacing 50
            side_xpos 1000
            draggable True
            mousewheel True
            for a in galleryList:
                frame:
                    xysize(384, 216)
                    if not ttr == a[0]:
                        background None
                    fixed:
                        xysize(384, 216)
                        imagebutton:
                            idle Transform(a[0], zoom=0.2)
                            insensitive Transform(im.Grayscale(a[0]), zoom=0.2)
                            tooltip a[0]
                            if persistent.lock:
                                action Replay(a[1], scope={"Fred": persistent.galleryname or "Fred", "Mary": persistent.sa_name or "Mary"}, locked=False)
                            else:
                                action Replay(a[1], scope={"Fred": persistent.galleryname or "Fred", "Mary": persistent.sa_name or "Mary"}, locked=False)
                    if ttr == a[0]:
                        text "{}".format(a[3]):
                            color "#ff0"
                            outlines [(2, "#000")]
                            underline True
                            bold True
                            xcenter 0.5
                            ycenter 0.4
                        text "{}".format(a[2]):
                            outlines [(2, "#000")]
                            xcenter 0.5
                            ycenter 0.6

### Text Style for Gallery Heading
style LHeading:
    color "#ff8c00"
    size 85
    xalign 0.5
    ypos 35
    outlines [(2, "#000")]

### Add Gallery Button to Main Menu
# Add this button to your main menu screen definition
#textbutton "Gallery" action [ui.callsinnewcontext("galleryname"), ShowMenu("gallerymod")]
