package main

type RefreshTokenResponse struct {
	Access    []interface{} `json:"access"`
	AccountID int64         `json:"account_id"`
	AddedDate string        `json:"added_date"`
	Data      struct {
		Country  string `json:"country"`
		Currency string `json:"currency"`
	} `json:"data"`
	ExpirationDate string        `json:"expiration_date"`
	IP             string        `json:"ip"`
	Key            string        `json:"key"`
	Meta           []interface{} `json:"meta"`
	RefreshToken   string        `json:"refresh_token"`
}

type SignOnWithApiKey struct {
	Account struct {
		AddedDate         string        `json:"added_date"`
		AddedIP           string        `json:"added_ip"`
		AvatarURL         string        `json:"avatar_url"`
		BirthDate         interface{}   `json:"birth_date"`
		Community         string        `json:"community"`
		Email             interface{}   `json:"email"`
		Gsm               interface{}   `json:"gsm"`
		ID                int64         `json:"id"`
		Lang              string        `json:"lang"`
		Locked            string        `json:"locked"`
		Login             string        `json:"login"`
		LoginDate         string        `json:"login_date"`
		LoginIP           string        `json:"login_ip"`
		Nickname          string        `json:"nickname"`
		ParentEmailStatus interface{}   `json:"parent_email_status"`
		Secure            interface{}   `json:"secure"`
		SecureInfo        interface{}   `json:"secure_info"`
		Security          []interface{} `json:"security"`
		Type              string        `json:"type"`
	} `json:"account"`
	Game struct {
		AddedDate             string      `json:"added_date"`
		BanEndDate            interface{} `json:"ban_end_date"`
		ExpirationDate        interface{} `json:"expiration_date"`
		FirstSubscriptionDate interface{} `json:"first_subscription_date"`
		FreeExpirationDate    interface{} `json:"free_expiration_date"`
		GameID                int64       `json:"game_id"`
		LoginDate             string      `json:"login_date"`
		LoginIP               string      `json:"login_ip"`
		Subscribed            bool        `json:"subscribed"`
		TotalTimeElapsed      int64       `json:"total_time_elapsed"`
	} `json:"game"`
	ID       int64  `json:"id"`
	IDString string `json:"id_string"`
}

type Server struct {
	Current int `json:"current"`
	Waiting int `json:"waiting"`
}