<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/debug-sentry', function() {
//	throw new Exception('Sentry error');
//}

Route::get('/', 'HomeController@index');

Auth::routes(['verify' => true]);

Route::get('/dashboard', 'ProgramController@dashboard')->name('dashboard');

Route::get('/account', 'ProfileController@account')->name('account_settings');
Route::post('/account', 'ProfileController@account_save')->name('account_save');
Route::post('/account/token', 'ProfileController@account_gen_api_token')->name('account_gen_api_token');

Route::prefix('oauth')->group(function () {
    Route::get('discord', 'ProfileController@redirectToDiscord')->name('discord_link');
    Route::get('discord/cb', 'ProfileController@handleDiscordCallback')->name('discord_callback');
});

Route::prefix('program')->group(function () {
    Route::post('new', 'ProgramController@_new')->name('program_new');
    Route::get('{id}', 'ProgramController@index')->name('program_view');

    Route::get('{id}/tokens', 'TokenController@index')->name('program_view_tokens');
    Route::post('{id}/tokens/new', 'TokenController@token_gen')->name('program_gen_tokens');
    Route::post('{id}/tokens/del', 'TokenController@token_del')->name('program_del_token');
    Route::post('{id}/tokens/del/used', 'TokenController@token_del_used')->name('program_del_used_tokens');
    Route::post('{id}/tokens/del/unused', 'TokenController@token_del_unused')->name('program_del_unused_tokens');
    Route::get('{id}/tokens/raw', 'TokenController@token_view_raw')->name('program_tokens_raw');

    Route::get('{id}/users', 'ProgramUserController@index')->name('program_view_users');
    Route::get('{id}/users/{uid}', 'ProgramUserController@view_user')->name('program_view_user');
    Route::post('{id}/users/{uid}', 'ProgramUserController@edit_user')->name('program_edit_user');
    Route::post('{id}/users/{uid}/hwid', 'ProgramUserController@hwid')->name('program_user_reset_hwid');
    Route::get('{id}/users/{uid}/del', 'ProgramUserController@delete')->name('program_user_delete');

    Route::get('{id}/settings', 'ProgramController@settings')->name('program_view_settings');
    Route::post('{id}/settings', 'ProgramController@save_settings')->name('program_save_settings');
    Route::post('{id}/delete', 'ProgramController@_delete')->name('program_delete');
    Route::post('{id}/share', 'ProgramController@share')->name('program_share');
    Route::post('{id}/share/{uid}/rem', 'ProgramController@share_rem')->name('program_share_rem');
    Route::post('{id}/share/{uid}/access', 'ProgramController@share_access')->name('program_share_access');

    Route::get('{id}/variables', 'NetworkVariableController@index')->name('program_view_variables');
    Route::post('{id}/variables/add', 'NetworkVariableController@add_variable')->name('program_add_variables');
    Route::post('{id}/variables/del', 'NetworkVariableController@del_variable')->name('program_del_variable');
});

Route::prefix('admin')->group(function () {
    Voyager::routes();
});

Route::view('/tos', 'tos');
Route::view('/privacy', 'privacy');
