<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->group(function () {
	Route::prefix('v1')->group(function() {
		Route::prefix('program')->group(function() {
			Route::get('/', 'APIController@program_list')->name('api_program_list');
			
			Route::prefix('{id}/user')->group(function() {
				Route::get('/', 'APIController@program_user_list')->name('api_program_list_user');
				Route::prefix('{uid}')->group(function() {
					Route::get('/', 'APIController@program_user_get')->name('api_program_get_user');
					Route::put('/', 'APIController@program_user_save')->name('api_program_save_user');
					Route::post('/hwid', 'APIController@program_user_hwid')->name('api_program_hwid_user');
				});
				Route::post('/authenticate', 'APIController@program_client_login')->name('api_program_client_login');
			});
			Route::prefix('{id}/token')->group(function() {
				Route::get('/', 'APIController@program_token_list')->name('api_program_list_token');
				Route::post('/', 'APIController@program_token_generate')->name('api_program_generate_token');
				Route::delete('{tid}', 'APIController@program_token_delete')->name('api_program_delete_token');
			});
			
			Route::prefix('{id}/variable')->group(function() {
				Route::get('/', 'APIController@program_variable_list')->name('api_program_list_variable');
				Route::post('/', 'APIController@program_variable_new')->name('api_program_create_variable');
				Route::delete('/{vid}', 'APIController@program_variable_delete')->name('api_program_delete_variable');
			});
			
			Route::get('{id}', 'APIController@program_settings_get')->name('api_program_get_settings');
			Route::put('{id}', 'APIController@program_settings_save')->name('api_program_save_settings');
		});
	});
});

Route::fallback(function(){
    return response()->json([
        'message' => 'Page Not Found. If error persists, contact admin@zertex.space'], 404);
});