@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <div class="card-text">
                    {{ $program->name }}
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3">
                    <div class="card border-info mx-sm-1 p-3">
                        <!--div class="card border-info shadow text-info p-3 my-card" ><span class="fa fa-car" aria-hidden="true"></span></div-->
                        <div class="text-info text-center mt-3"><h4>Tokens</h4></div>
                        <div class="text-info text-center mt-2"><h1>{{ $program->tokens()->count() }}</h1></div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-danger mx-sm-1 p-3">
                        <!--div class="card border-info shadow text-info p-3 my-card" ><span class="fa fa-car" aria-hidden="true"></span></div-->
                        <div class="text-info text-center mt-3"><h4>Users</h4></div>
                        <div class="text-info text-center mt-2"><h1>{{ $program->users()->count() }}</h1></div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-warning mx-sm-1 p-3">
                        <!--div class="card border-info shadow text-info p-3 my-card" ><span class="fa fa-car" aria-hidden="true"></span></div-->
                        <div class="text-info text-center mt-3"><h4>Current Version</h4></div>
                        <div class="text-info text-center mt-2"><h1>{{ $program->version }}</h1></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
