@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <div class="card-text">
                    {{ $program->name }} Variables
                </div>
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('program_add_variables', $program->id) }}">
                @csrf
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-sticky-note"></i>&nbsp;Name
                        </div>
                    </div>
                    <input type="text" name="name" class="form-control">
                </div>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-edit"></i>&nbsp;Value
                        </div>
                    </div>
                    <input type="text" name="value" class="form-control">
                </div>

                <button type="submit" class="btn btn-success"><i class="fas fa-plus-square"></i>&nbsp;Create Variable</button>
            </form>
            <hr/>
            <table class="table table-striped table-hover">
                <thead>
                <tr>
                    <th scope="col">
                        Name
                    </th>
                    <th scope="col">
                        Value
                    </th>
                    <th scope="col" width="15%">
                        Actions
                    </th>
                </tr>
                </thead>
                <tbody>
                    @foreach($program->variables()->get() as $variable)
                        <tr>
                            <th scope="col">
                                {{ $variable->name }}
                            </th>
                            <td>
                                {{ $variable->value }}
                            </td>
                            <td>
                                <form method="POST" action="{{ route('program_del_variable', $program->id) }}">
                                    @csrf
                                    <input hidden name="variable_id" value="{{ $variable->id }}">
                                    <button type="submit" class="btn btn-danger"><i class="fas fa-trash-alt"></i>&nbsp;Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
