@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <div class="card-text">
                    {{ $program->name }} Users
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <th scope="col">
                        Username
                    </th>
                    <th scope="col">
                        Expires
                    </th>
                    <th scope="col" width="25%">
                        Actions
                    </th>
                </thead>
                <tbody>
                    @foreach($program->users()->get() as $user)
                        <tr>
                            <th scope="col">
                                {{ $user->username }}
                            </th>
                            <td>
                                {{ $user->expires }}
                            </td>
                            <td>
                                <div class="inline">
                                    <a href="{{ route('program_view_user', ['id'=>$program->id, 'uid'=>$user->id]) }}">
                                        <button class="btn btn-warning"><i class="fas fa-sticky-note"></i>&nbsp;Edit</button>
                                    </a>
                                    <a href="{{ route('program_user_delete', ['id' => $program->id, 'uid' => $user->id]) }}"><button type="submit" class="btn btn-danger" form="del_form_{{ $user->id }}"><i class="fas fa-trash-alt"></i>&nbsp;Delete</button></a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
