@extends('layouts.app')

@section('content')
	<div class="card">
		<div class="card-header">
			<div class="card-title">
				<div class="card-text">
					{{ $program->name }} Editing User
				</div>
			</div>
		</div>
	<div class="card-body">
		<form method="POST" action="{{ route('program_edit_user', ['id'=>$program->id, 'uid'=>$user->id]) }}" id="edit" name="edit">
			@csrf
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						<i class="fas fa-user"></i>&nbsp;Username
					</div>
				</div>
				<input type="text" class="form-control" readonly value="{{ $user->username }}">
			</div>
			
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						<i class="fas fa-key"></i>&nbsp;Password
					</div>
				</div>
				<input type="text" class="form-control" name="password" placeholder="Enter new password">
			</div>
			
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						<i class="fas fa-envelope"></i>&nbsp;Email
					</div>
				</div>
				<input type="text" class="form-control" name="email" value="{{ $user->email }}">
			</div>
			
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						<i class="fas fa-level-up-alt"></i>&nbsp;Level
					</div>
				</div>
				<input type="text" class="form-control" name="level" value="{{ $user->level }}">
			</div>
			
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						<i class="fas fa-lock"></i>&nbsp;HWID
					</div>
				</div>
				<input type="text" class="form-control" name="hwid" value="{{ $user->HWID }}">
			</div>
			
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						<i class="fas fa-user-clock"></i>&nbsp;Expires
					</div>
				</div>
				<input type="text" class="form-control" name="expires" value="{{ $user->expires }}">
			</div>
			<button class="btn btn-success form-control" type="submit"><i class="fas fa-save"></i>&nbsp;Save User</button>
		</form>
		<br/>
		<form method="POST" action="{{ route('program_user_reset_hwid', ['id'=>$program->id, 'uid'=>$user->id]) }}">
			@csrf
			<button class="btn btn-success form-control" type="submit"><i class="fas fa-retweet"></i>&nbsp;Reset HWID</button>
		</form>
	</div>
</div>
@endsection