@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <div class="card-text">
                    {{ $program->name }} Tokens
                </div>
            </div>
        </div>
        <div class="card-body">
            <form action="{{ route('program_gen_tokens', $program->id) }}" method="POST" id="gen_form" name="gen_form">
                @csrf
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-stopwatch"></i>&nbsp;Length
                        </div>
                    </div>
                    <select class="custom-select" name="token_length">
                        <option selected>Choose...</option>
                        <option value="1">One Day</option>
			<option value="2">Three Days</option>
			<option value="3">One Week</option>
                        <option value="4">One Month</option>
                        <option value="5">Three Months</option>
                        <option value="6">One Year</option>
                        <option value="7">Lifetime</option>
                    </select>
                </div>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-level-up-alt"></i>&nbsp;Level
                        </div>
                    </div>
                    <input type="number" name="token_level" min="1" max="10" class="form-control" placeholder="1 to 10">
                </div>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-align-justify"></i>&nbsp;Amount
                        </div>
                    </div>
                    <input type="number" max="100" min="1" name="token_amount" placeholder="1 to 100" class="form-control">
                </div>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-step-backward"></i>&nbsp;Custom Prefix
                        </div>
                    </div>
                    <input type="text" class="form-control" name="token_prefix">
                </div>


            </form>
            <form method="POST" action="{{ route('program_del_used_tokens', $program->id) }}" id="del_used" name="del_used">
                @csrf
            </form>
            <form method="POST" action="{{ route('program_del_unused_tokens', $program->id) }}" id="del_unused" name="del_unused">
                @csrf
            </form>

            <div class="inline">
                <button type="submit" class="btn btn-success" form="gen_form"><i class="far fa-plus-square"></i>&nbsp;Generate</button>
                <button class="btn btn-danger" type="submit" form="del_used"><i class="fas fa-trash-alt"></i>&nbsp;Delete Used</button>
                <button class="btn btn-danger" type="submit" form="del_unused"><i class="fas fa-trash-alt"></i>&nbsp;Delete Unused</button>
                <a href="{{route('program_tokens_raw', $program->id) }}"><button class="btn btn-warning"><i class="fas fa-folder-open"></i>&nbsp;View Raw</button></a>
            </div>
            <hr/>
            <table class="table table-striped table-hover">
                <thead>
                    <th scope="col">
                        Token
                    </th>
                    <th scope="col">
                        Days
                    </th>
                    <th scope="col">
                        Level
                    </th>
                    <th scope="col">
                        Used by
                    </th>
                    <th scope="col" width="15%">
                        Actions
                    </th>
                </thead>
                <tbody>
                    @foreach($program->tokens()->get() as $token)
                        <tr>
                            <th scope="col">
                                {{ $token->token }}
                            </th>
                            <td>
                                {{ $token->days }}
                            </td>
                            <td>
                                {{ $token->level }}
                            </td>
                            <td>
                                @if($token->used == 1)
                                    {{ \App\ProgramUser::where('id', $token->used_by)->first()->username }}
                                @else
                                    Not used
                                @endif
                            </td>
                            <td>
                                <form method="POST" action="{{ route('program_del_token', $program->id) }}">
                                    @csrf
                                    <input hidden name="token_id" value="{{ $token->id }}">
                                    <button type="submit" class="btn btn-danger"><i class="fas fa-trash-alt"></i> Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
