@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <div class="card-text">
                    {{ $program->name }} Settings
                </div>
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('program_save_settings', $program->id) }}">
                @csrf

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-file-signature"></i>&nbsp;Name
                        </div>
                    </div>
                    <input type="text" class="form-control" name="name" value="{{ $program->name }}">
                </div>
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-hashtag"></i>&nbsp;Hash
                        </div>
                    </div>
                    <input type="text" class="form-control" name="hash" value="{{ $program->hash }}">
                </div>
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-unlock-alt"></i>&nbsp;Key
                        </div>
                    </div>
                    <input readonly type="text" class="form-control" value="{{ $program->key }}">
                </div>
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-key"></i>&nbsp;Variable Key
                        </div>
                    </div>
                    <input readonly type="text" class="form-control" value="{{ $program->varkey }}">
                </div>
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-power-off"></i>&nbsp;Enabled
                        </div>
                    </div>
                    <select class="custom-control custom-select" name="enabled">
                        <option value="0"@if($program->enabled == 0) selected @endif>Disabled</option>
                        <option value="1" @if($program->enabled == 1) selected @endif>Enabled</option>
                    </select>
                </div>
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fab fa-dev"></i>&nbsp;Dev-Mode
                        </div>
                    </div>
                    <select class="custom-select" name="devmode">
                        <option value="0" @if($program->devmode == 0) selected @endif>Disabled</option>
                        <option value="1" @if($program->devmode == 1) selected @endif>Enabled</option>
                    </select>
                </div>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-link"></i>&nbsp;Url
                        </div>
                    </div>
                    <input type="text" class="form-control" name="url" value="{{ $program->url }}">
                </div>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-code-branch"></i>&nbsp;Version
                        </div>
                    </div>
                    <input type="text" class="form-control" name="version" value="{{ $program->version }}">
                </div>

                <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> &nbsp;Save Settings</button>
            </form>
            <hr/>
            <form method="POST" action="{{ route('program_delete', $program->id) }}">
                @csrf
                <button class="btn btn-danger" type="submit"><i class="fas fa-exclamation-triangle"></i> &nbsp;Delete Program</button>
            </form>
        </div>
    </div>
    <br/>
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                Collaboration
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('program_share', $program->id) }}">
                @csrf
                <p>To share this application with another user, enter their name or email in the following box and click "Share"!</p>

                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <i class="fas fa-user-circle"></i>
                        </div>
                    </div>
                    <input type="text" name="user" id="name" class="form-control" placeholder="User or Email">
                </div>

                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <label class="input-group-text">
                                <i class="fas fa-universal-access"></i>&nbsp;Access Level
                            </label>
                        </div>
                        <select class="custom-select form-control" id="access" name="access">
                            <option value="1">Reseller</option>
                            <option value="2">Moderator</option>
                            <option value="3">Developer</option>
                        </select>
                    </div>
                    <small class="form-text text-muted">Resellers only have access to tokens.  Moderators can access users/tokens. Developers can do everything except delete the program / manage other collaborators.</small>
                </div>

                <button class="btn btn-warning" type="submit"><i class="fas fa-share-square"></i>&nbsp;Share</button>
            </form>
            <hr/>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th scope="col">
                            Username
                        </th>
                        <th scope="col">
                            Access Level
                        </th>
                        <th scope="col" width="25%">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($shared_with->get() as $user)
                        <tr>
                            <th scope="col">
                                {{ $user->name }}
                            </th>
                            <td>
                                <form method="POST" action="{{ route('program_share_access', ['id'=>$program->id, 'uid'=>$user->id]) }}">
                                    @csrf
                                    <div class="input-group mb-3">
                                        <div class="input-group-prepend">
                                            <button class="btn btn-outline-success" type="submit"><i class="fa fa-save"></i> &nbsp;Save</button>
                                        </div>
                                        <select class="custom-select" id="access" name="access">
                                            <option value="1" @if($user->pivot->access == 1) selected @endif>Reseller</option>
                                            <option value="2" @if($user->pivot->access == 2) selected @endif>Moderator</option>
                                            <option value="3" @if($user->pivot->access == 3) selected @endif>Developer</option>
                                        </select>
                                    </div>
                                </form>
                            </td>
                            <td>
                                <form method="POST" action="{{ route('program_share_rem', ['id'=>$program->id, 'uid'=>$user->id]) }}">
                                    @csrf
                                    <button type="submit" class="btn btn-danger"><i class="fas fa-eraser"></i> &nbsp;Remove</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
