@extends('layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                Your Programs
            </div>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th width="10%">
                            Program ID
                        </th>
                        <th scope="col">
                            Name
                        </th>
                        <th scope="col">
                            Program Key
                        </th>
                        <th scope="col">
                            Users
                        </th>
                        <th scope="col" width="10%">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($programs as $program)
                        <tr>
                            <th>
                                {{ $program->id }}
                            </th>
                            <td>
                                {{ $program->name }}
                            </td>
                            <td>
                                {{ $program->key }}
                            </td>
                            <td>
                                {{ $program->users()->count() }}
                            </td>
                            <td>
                                <a href="{{ route('program_view', $program->id) }}">
                                    <button class="btn btn-info"><i class="fas fa-folder-open"></i>&nbsp;View</button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <br/>
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                Shared Programs
            </div>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th width="10%">
                            Program ID
                        </th>
                        <th scope="col">
                            Owner
                        </th>
                        <th scope="col">
                            Name
                        </th>
                        <th scope="col">
                            Users
                        </th>
                        <th scope="col" width="10%">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($secondary as $program)
                        <tr>
                            <th>
                                {{ $program->id }}
                            </th>
                            <td>
                                {{ $program->owner()->first()->name }}
                            </td>
                            <td>
                                {{ $program->name }}
                            </td>
                            <td>
                                {{ $program->users()->count() }}
                            </td>
                            <td>
                                <a href="{{ route('program_view', $program->id) }}">
                                    <button class="btn btn-info">View</button>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <br/>
    <div class="card">
        <div class="card-header">
            <div class="card-title">
                <div class="card-text">Create New Program</div>
            </div>
        </div>
        <div class="card-body align-content-center text-center">
            <form method="POST" action="{{ route('program_new') }}">
                @csrf
                <div class="form-group input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text"><i class="fas fa-plus-square"></i></div>
                    </div>
                    <input type="text" id="program_name" class="form-control" name="program_name" placeholder="Program Name">
                </div>
                <button class="btn btn-success btn-lg btn-block" type="submit">Create</button>
            </form>
            <hr/>
            <div class="text-center align-content-center">
                <p>
                    Programs {{ \Auth::user()->programs()->count() }} / {{ \Auth::user()->program_allowance() }}
                </p>
                <p>
                    Your account status: {{ \Auth::user()->role->display_name }}
                </p>
		<p>
		    <a href="https://files.zertex.space/QALib.rar">Latest files (Version 1.7)</a>
			<br/>
		    <small>Stronk packer</small>
		</p>
            </div>
        </div>
    </div>
@endsection
