@extends('layouts.app')

@section('content')
	<div class="card">
		<div class="card-header">
			<div class="card-title">
				Account Settings
			</div>
		</div>
		<div class="card-body">
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						Username
					</div>
				</div>
				<input type="text" class="form-control" readonly value="{{ \Auth::user()->name }}">
			</div>
			<div class="form-group input-group">
				<div class="input-group-prepend">
					<div class="input-group-text">
						Email
					</div>
				</div>
				<input type="text" class="form-control" readonly value="{{ \Auth::user()->email }}">
			</div>
			<hr/>
			<h3>Change password</h3>
			<form method="POST" action="{{ route('account_save') }}">
				@csrf
				<div class="form-group input-group">
					<div class="input-group-prepend">
						<div class="input-group-text">
							Current Password
						</div>
					</div>
					<input type="password" name="cur_pass" class="form-control">
				</div>
				<div class="form-group input-group">
					<div class="input-group-prepend">
						<div class="input-group-text">
							New Password
						</div>
					</div>
					<input type="password" name="pass" class="form-control">
				</div>
				<div class="form-group input-group">
					<div class="input-group-prepend">
						<div class="input-group-text">
							New Password Confirm
						</div>
					</div>
					<input type="password" name="pass_conf" class="form-control">
				</div>
				<button type="submit" class="btn btn-success"><i class="fas fa-save"></i>&nbsp;Set New Password</button>
			</form>
			<hr/>
			<a href="{{ route('discord_link') }}"><button class="btn btn-primary"><i class="fab fa-discord"></i>@if(\Auth::user()->discord_id() != -1) Re-Link Discord @else Link Discord @endif</button></a>
			<hr/>
			<form method="POST" action="{{ route('account_gen_api_token') }}">
				@csrf
				<div class="form-group input-group">
					<div class="input-group-prepend">
						<div class="input-group-text">
							Token
						</div>
					</div>
					<input type="text" readonly class="form-control" value="{{ \Auth::user()->api_token }}">
				</div>
				<button type="submit" class="btn btn-warning">Generate new API Token</button>
				<br/><small>This will break any applications you are using your token for!</small>
			</form>
		</div>
	</div>
@endsection