<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTokensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tokens', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('token');
            $table->boolean('used')->default(0);
            $table->integer('days');
            $table->integer('level');
            $table->unsignedBigInteger('used_by')->nullable();
            $table->unsignedBigInteger('program_id');
            $table->timestamps();

            $table->foreign('used_by')->references('id')->on('program_users');
            $table->foreign('program_id')->references('id')->on('programs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tokens');
    }
}
