<?php

namespace App\Widgets;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use TCG\Voyager\Facades\Voyager;
use TCG\Voyager\Widgets\BaseDimmer;

class APIDimmer extends BaseDimmer
{
    /**
     * The configuration array.
     *
     * @var array
     */
    protected $config = [];

    /**
     * Treat this method as a controller action.
     * Return view() or other content to display.
     */
    public function run()
    {
        $api_running = $this->processExists("QuartzAuthApi");
        $status = "Running";
        if (!$api_running) {
            $status = "Not Running";
        }

        return view('voyager::dimmer', array_merge($this->config, [
            'icon'   => 'voyager-data',
            'title'  => "API Service",
            'text'   => __('API is currently :status!', ['status' => $status]),
            'button' => [
                'text' => "Nop",
                'link' => "#",
            ],
            'image' => voyager_asset('images/widget-backgrounds/03.jpg'),
        ]));
    }

    function processExists($processName) {
        $exists= false;
        exec("ps -A | grep -i $processName | grep -v grep", $pids);
        if (count($pids) > 0) {
            $exists = true;
        }
        return $exists;
    }

    /**
     * Determine if the widget should be displayed.
     *
     * @return bool
     */
    public function shouldBeDisplayed()
    {
        return true;
    }
}
