<?php

namespace App;

use Soved\Laravel\Gdpr\Portable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Soved\Laravel\Gdpr\Contracts\Portable as PortableContract;

class User extends \TCG\Voyager\Models\User implements PortableContract, MustVerifyEmail
{
    use Portable, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    
    /**
     * The relations to include in the downloadable data.
     *
     * @var array
     */
    protected $gdprWith = ['programs'];
    
    /**
     * The attributes that should be hidden for the downloadable data.
     *
     * @var array
     */
    protected $gdprHidden = ['password'];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function programs() {
        return $this->hasMany('App\Program', 'owner_id');
    }
    
    public function program_allowance() {
        if ($this->hasRole('admin') || $this->hasRole('premium')) {
            return 9999;
        }
        return 5;
    }
    
    public function token_allowance() {
        if ($this->hasRole('admin') || $this->hasRole('premium')) {
            return 999999;
        }
        return 100;
    }
    
    public function admin_programs() {
        return $this->belongsToMany('App\Program', 'program_admins', 'user_id', 'program_id')->withPivot('access');
    }
    
    public function discord_id() {
        $res = \DB::table('discord_link')->where('user_id', $this->id);
        if ($res->count() == 0)
            return -1;
        return $res->first()->discord_id;
    }
}
