<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Program extends Model
{
    protected $fillable = [
        'name', 'key', 'varkey', 'owner_id'
    ];

    public function users() {
        return $this->hasMany('App\ProgramUser');
    }

    public function tokens() {
        return $this->hasMany('App\Token');
    }

    public function variables() {
        return $this->hasMany('App\NetworkVariable');
    }
    
    public function owner() {
        return $this->belongsTo('App\User');
    }
    
    public function shared_with() {
        return $this->belongsToMany('App\User', 'program_admins', 'program_id', 'user_id')->withPivot('access');
    }
    
    public function generate_tokens($count, $length, $level, $prefix='') {
        switch ($length) {
            case 1:
                $length = 1;
                break;
            case 2:
                $length = 3;
                break;
            case 3:
		$length = 7;
		break;
	    case 4:
		$length = 30;
		break;
            case 5:
                $length = 90;
                break;
            case 6:
                $length = 365;
                break;
            case 7:
                $length = 999999;
        }

        if (strlen($prefix) > 0) {
            $prefix .= '-';
        }
        
        $array = [];
        for ($i = 0; $i < $count; $i++) {
            array_push($array, [
                'token' => $prefix.\Str::random(20),
                'days' => $length,
                'level' => $level,
                'program_id' => $this->id
            ]);
        }
        Token::insert($array);
    }
}
