<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Program;
use App\Token;

class TokenController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index($id) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->wherePivot('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 1) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        return view('program_tokens', ['program' => $program->first()]);
    }

    public function token_del(Request $request, $id) {
        $request->validate([
            'token_id' => 'required|exists:tokens,id'
        ]);

        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 1) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }
        $tid = $request->input('token_id');

        $program->first()->tokens()->where('id', $tid)->first()->delete();
        return redirect(route('program_view_tokens', $id))->withStatus('Deleted token with success');
    }

    public function token_del_used($id) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 1) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $tokens = Token::where('program_id', $program->first()->id)->where('used', 1);
        foreach($tokens->get() as $token) {
            $token->delete();
        }
        return redirect(route('program_view_tokens', $id))->with('status', 'Deleted tokens');
    }

    public function token_del_unused($id) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 1) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $tokens = Token::where('program_id', $program->first()->id)->where('used', 0);
        foreach($tokens->get() as $token) {
            $token->delete();
        }
        return redirect(route('program_view_tokens', $id))->with('status', 'Deleted tokens');
    }

    public function token_view_raw($id) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 1) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $tokens = Token::where('program_id', $program->first()->id)->where('used', 0);

        $one_day = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 1)->get();
	$three_day = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 3)->get();
	$one_week = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 7)->get();
        $one_month = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 30)->get();
        $three_months = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 90)->get();
        $one_year = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 365)->get();
        $lifetime = Token::where('program_id', $program->first()->id)->where('used', 0)->where('days', 99999)->get();

        return view('program_tokens_raw', ["program" => $program->first(), 'one_day' => $one_day, 'three_day' => $three_day, 'one_week' => $one_week, 'one_month' => $one_month, 'three_months' => $three_months, 'one_year' => $one_year, 'lifetime' => $lifetime]);
    }

    public function token_gen(Request $request, $id) {
        $request->validate([
            'token_amount' => 'required|between:1,100',
            'token_length' => 'required|between:1,7',
            'token_level' => 'required|between:1,10',
            'token_prefix' => 'nullable|string|max:25'
        ]);

        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 1) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }
        $count = $request->input('token_amount');
        $length = $request->input('token_length');
        $level = $request->input('token_level');
        $prefix = $request->input('token_prefix', '');

        $program->first()->generate_tokens($count, $length, $level, $prefix);

        return redirect()->back()->withStatus('Generated '.$count.' tokens');
    }
}
