<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Program;
use App\ProgramUser;
use Composer\DependencyResolver\Rule;

class ProgramUserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index($id) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 2) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        return view('program_users', ['program' => $program->first()]);
    }

    public function view_user($id, $uid) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 2) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $user = $program->first()->users()->where('id', $uid);

        if ($user->count() == 0) {
            return redirect(route('program_view_users'))->with('errors', ['Invalid User']);
        }

        return view('program_user_edit', ['program'=>$program->first(), 'user'=>$user->first()]);
    }

    public function edit_user(Request $request, $id, $uid) {
        $request->validate([
            'email' => 'required',
            'password' => 'nullable',
            'hwid' => 'nullable|string',
            'expires' => 'required|date',
            'level' => 'required|integer|between:1,10'
        ]);
        
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 2) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $user = $program->first()->users()->where('id', $uid);

        if ($user->count() == 0) {
            return redirect(route('program_view_users'))->withErrors(['user' => 'Invalid User']);
        }

        $user = $user->first();
        
        if (strlen($request->password) > 0)
            $user->password = password_hash($request->password, PASSWORD_BCRYPT, ['cost' => 14]);
	    if(strlen($request->hwid) > 0)
	        $user->hwid = $request->hwid;
        if (strlen($request->expires) > 0)
            $user->expires = $request->expires;
        $user->email = $request->email;
        
        $user->save();

        return redirect()->back()->with('status', 'Successfully edited user');
    }

    public function hwid($id, $uid) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 2) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $user = $program->first()->users()->where('id', $uid)->first();

        if ($user->count() == 0) {
            return redirect(route('program_view_users'))->withErrors(['user' => 'Invalid User']);
        }

        $user->hwid = '';
        $user->save();

        return redirect()->back()->withStatus('Reset HWID');
    }

    public function delete($id, $uid) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 2) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $user = $program->first()->users()->where('id', $uid);

        if ($user->count() == 0) {
            return redirect(route('program_view_users', $id))->withErrors(['user' => 'Invalid User']);
        }

        $user->first()->delete();

        return redirect(route('program_view_users', $id))->withStatus('Deleted user');
    }
    
    public function view_pass_reset($token) {
        
    }
}
