<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ProfileController extends Controller
{
	public function __construct() {
		$this->middleware('auth');
	}
	
	public function account() 
	{
	    return view('account_settings');
	}
	
	public function account_save(Request $request) 
	{
			$request->validate([
	        'cur_pass' => 'required',
	        'pass' => [
	            'required',
	            'string',
	            'min:10',             // must be at least 10 characters in length
	            'regex:/[a-z]/',      // must contain at least one lowercase letter
	            'regex:/[A-Z]/',      // must contain at least one uppercase letter
	            'regex:/[0-9]/',      // must contain at least one digit
	            'regex:/[@$!%*#?&]/', // must contain a special character
	        ],
	        'pass_conf' => 'required|same:pass'
	    ]);
		
	    $cur = $request->cur_pass;
	    $new = $request->pass;
	    $user = \Auth::user();
	    if(!Hash::check($cur, $user->password)) {
	    	return redirect()->back()->withErrors('Invalid password!');
	    }
	    
	    $user->password = Hash::make($new);
	    
	    return redirect()->back()->withStatus('Saved settings!');
	}
	
	public function account_gen_api_token()
	{
	    $user = \Auth::user();
	    $user->api_token = \Str::random(60);
	    $user->save();
	    
	    return redirect()->back()->withStatus('Generated new API token!');
	}
	
	public function redirectToDiscord() {
	    return \Socialite::with('discord')->redirect();
	}
	
	public function handleDiscordCallback() {
	    $user = \Socialite::driver('discord')->user();
	    
	    \DB::table('discord_link')->updateOrInsert(['user_id' => \Auth::user()->id, 'discord_id' => $user->id]);
	    
	    return redirect(route('dashboard'))->withStatus('Linked discord, now you can use the bot to administrate your applications.');
	}
}
