<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Program;
use App\NetworkVariable;

class NetworkVariableController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index($id) {
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 3) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        return view('program_variables', ['program' => $program->first()]);
    }

    public function add_variable(Request $request, $id) {
        $request->validate([
            'name' => 'required|max:255',
            'value' => 'required|max:255'
        ]);
        
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 3) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        if ($program->first()->variables()->where('name', $request->name)->count() > 0) {
            return redirect()->back()->withErrors(['input' => 'Variable already exists']);
        }

        NetworkVariable::create([
            'name' => $request->name,
            'value' => $request->value,
            'program_id' => $program->first()->id,
        ]);

        return redirect()->back()->withStatus('Created variable');
    }

    public function del_variable(Request $request, $id) {
        $request->validate([
            'variable_id' => 'required|integer|gt:0'
        ]);
        $program = Program::where('owner_id', \Auth::user()->id)->where('id', $id);
        if ($program->count() == 0) {
            $program = \Auth::user()->admin_programs()->where('program_id', $id);
            if ($program->count() == 0) {
                return redirect(route('dashboard'))->withErrors(['application' => 'Invalid Application']);
            }
            if ($program->first()->pivot->access < 3) {
                return redirect(route('dashboard'))->withErrors(['permissions' => 'Invalid Permissions']);
            }
        }

        $vid = $request->input('variable_id', '-1');
        if ($vid == -1) {
            return redirect()->back()->withErrors(['token' => 'Invalid Token']);
        }

        $program->first()->variables()->where('id', $vid)->first()->delete();

        return redirect()->back()->withStatus('Deleted Variable');
    }
}
