<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {

	if (app()->bound('sentry') && $this->shouldReport($exception)) {
		app('sentry')->captureException($exception);
	}

        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception) // https://laraveldaily.com/laravel-api-errors-and-exceptions-how-to-return-responses/
    {
        if ($exception instanceof ModelNotFoundException) {
            return response()->json(['status' => 'failure',
                'error' => 'Entry for '.str_replace('App\\', '', $exception->getModel()).' not found'], 404);
        }
        
        return parent::render($request, $exception);
    }
}
