package auth

import (
	"bufio"
	"encoding/json"
	"fmt"
	"github.com/logrusorgru/aurora"
	"github.com/pkg/browser"
	"github.com/shirou/gopsutil/host"
	"golang.org/x/crypto/ssh/terminal"
	"git.zertex.space/Zertex/QuartzSniper/utils"
	"io/ioutil"
	"net"
	"os"
	"strings"
	"syscall"
	"time"
)

var
(
	Connection net.Conn
	Version = "3"
	Key = "5Df34oCKKUgEeFAlTS05RrT1tvlVxesGykorQs1S"
	VKey = "kKiOIpLB3NMhNDZub4IappZmei30bE"
	Expiry time.Time
	ClientUsername = ""
	Password = ""
	Hash = ""
)

func init() {
	var err error
	Hash, err = utils.GetFileHash(os.Args[0])
	if err != nil {
		utils.LogError(err.Error())
	}
}

func GetAuth() bool {
	if ! Heartbeat() {
		utils.LogInfo("failed heartbeat")
		return false
	}
	if utils.FileExists(".qa") {
		b,err := ioutil.ReadFile(".qa")
		str := strings.Split(utils.Decrypt(string(b), "xNz#'%/2n4SZsB>m"), ":")
		if err == nil {
			resp := Login(str[0], str[1])
			ClientUsername = str[0]
			utils.LogInfo("Authenticating...")
			if resp.Status == "success" {
				Expiry = resp.Expiry
				return true
			}
		}
	}
	for {
		utils.CallClear()
		fmt.Println(aurora.Magenta(utils.Banner))
		fmt.Print("[0] Login\r\n[1] Register\r\n[2] Renew\r\nWhat would you like to do? ")
		opt := utils.GetInputStr()
		var fs *FromServer
		switch opt {
		case "0":
			fs = LoginCMD()
			fmt.Println(fs)
			if fs.Status != "success" {
				if fs.Message == "invalid_hwid" {
					utils.LogError("Invalid hwid")
				} else {
					utils.LogError("Invalid login")
				}
			}
		case "1":
			fs = RegisterCMD()
			if fs.Status != "success" {
				utils.LogError("Failed to register")
			} else {
				utils.LogInfo("Registered!  Please login.")
			}
		case "2":
			fs = RenewCMD()
			if fs.Status != "success" {
				utils.LogError("Failed to redeem")
			}
		default:
			utils.LogError("invalid option")
		}

		if fs == nil {
			continue
		}

		if fs.Status == "success" && fs.Message == "authenticated" {
			ioutil.WriteFile(".xdg", []byte(utils.Encrypt(fmt.Sprintf("%s:%s", ClientUsername, Password), "xNz#'%/2n4SZsB>m")), 0644)
			return true
		}

		time.Sleep(4 * time.Second)
	}
}

func DoTransaction(ts *ToServer) *FromServer {
	ts.HWID = GetHWID()
	ts.Key = Key
	ts.VKey = VKey
	ts.Session = utils.StringOfLength(32)
	ts.Salt = utils.StringOfLength(16)
	ts.Version = Version
	ts.Hash = Hash

	jsonstr, err := json.Marshal(EncryptPayload(ts))
	if err != nil {
		fmt.Println(err.Error())
		return nil
	}
	payload := utils.Encrypt(string(jsonstr), "zLy&CyLg#tvUp4aH6tDH7F%fx=w6xCa%r_A^3hkq468nuuc5=7xba^un&bYLeQ=C-qL_hp#rnNU5a!5neb%_&aygXDL8Jg7?Y6cHpLAtEXM&kbfGTzyQm3Lv")
	//fmt.Println(payload)
	// send to socket
	Connection, err = net.Dial("tcp", "37.228.132.179:3333")
	if err != nil {
		utils.LogError(err.Error())
	}
	fmt.Fprintf(Connection, payload + "\n")
	//fmt.Println("sent! awaiting response...")
	// listen for reply
	resp, _ := bufio.NewReader(Connection).ReadString('\n')
	message := utils.Decrypt(resp, "zLy&CyLg#tvUp4aH6tDH7F%fx=w6xCa%r_A^3hkq468nuuc5=7xba^un&bYLeQ=C-qL_hp#rnNU5a!5neb%_&aygXDL8Jg7?Y6cHpLAtEXM&kbfGTzyQm3Lv")
	var fs *FromServer
	err = json.Unmarshal([]byte(message), &fs)
	if err != nil {
		fmt.Println(err.Error())
		return nil
	}
	return DecryptPayload(fs, ts.Session, ts.Salt)
}

func GetHWID() string {
	hostStat, err := host.Info()
	if err != nil {
		panic(err)
	}

	return hostStat.HostID
}

func DecryptPayload(tc *FromServer, pass string, salt string) *FromServer {
	tc.Status = utils.DecryptWithSalt(tc.Status, pass, salt)
	tc.Message = utils.DecryptWithSalt(tc.Message, pass, salt)
	tc.Data = utils.DecryptWithSalt(tc.Data, pass, salt)
	return tc
}

func EncryptPayload(fc *ToServer) *ToServer {
	fc.Username = utils.EncryptWithSalt(fc.Username, fc.Session, fc.Salt)
	fc.Password = utils.EncryptWithSalt(fc.Password, fc.Session, fc.Salt)
	fc.Email = utils.EncryptWithSalt(fc.Email, fc.Session, fc.Salt)
	fc.HWID = utils.EncryptWithSalt(fc.HWID, fc.Session, fc.Salt)
	fc.Hash = utils.EncryptWithSalt(fc.Hash, fc.Session, fc.Salt)
	fc.Data = utils.EncryptWithSalt(fc.Data, fc.Session, fc.Salt)
	fc.Key = utils.EncryptWithSalt(fc.Key, fc.Session, fc.Salt)
	fc.Version = utils.EncryptWithSalt(fc.Version, fc.Session, fc.Salt)
	fc.PacketType = utils.EncryptWithSalt(fc.PacketType, fc.Session, fc.Salt)
	return fc
}

func Login(username string, password string) *FromServer {
	resp := DoTransaction(&ToServer{
		Username:username,
		Password:password,
		PacketType:"authenticate",
	})

	ClientUsername = username
	Password = password
	Expiry = resp.Expiry

	if resp.Status == "success" {
		ioutil.WriteFile(".qa", []byte(utils.Encrypt(fmt.Sprintf("%s:%s", ClientUsername, Password), "xNz#'%/2n4SZsB>m")), 0644)
	}

	return resp
}

func LoginCMD() *FromServer {
	for {
		// read in input from stdin
		reader := bufio.NewReader(os.Stdin)
		fmt.Print("Username: ")
		username, _ := reader.ReadString('\n')
		username = strings.ReplaceAll(strings.ReplaceAll(username, "\n", ""), "\r", "")
		fmt.Print("Password: ")
		passwd, _ := terminal.ReadPassword(int(syscall.Stdin))
		pass := strings.ReplaceAll(strings.ReplaceAll(string(passwd), "\n", ""), "\r", "")
		fmt.Println()

		return Login(username, pass)
	}
}

func Register(username string, email string, password string, token string) *FromServer {
	resp := DoTransaction(&ToServer{
		Username:   username,
		Password:   password,
		Email:      email,
		PacketType: "register",
		Data:       token,
	})

	ClientUsername = username
	Password = password
	Expiry = resp.Expiry

	if resp.Status == "success" {
		ioutil.WriteFile(".xdg", []byte(utils.Encrypt(fmt.Sprintf("%s:%s", ClientUsername, Password), "xNz#'%/2n4SZsB>m")), 0644)
	}

	return resp
}

func RegisterCMD() *FromServer {
	for {
		reader := bufio.NewReader(os.Stdin)
		fmt.Print("Username: ")
		username, _ := reader.ReadString('\n')
		username = strings.ReplaceAll(strings.ReplaceAll(username, "\n", ""), "\r", "")
		fmt.Print("Password: ")
		passwd, _ := terminal.ReadPassword(int(syscall.Stdin))
		pass := strings.ReplaceAll(strings.ReplaceAll(string(passwd), "\n", ""), "\r", "")
		fmt.Println()
		fmt.Print("Email: ")
		email, _ := reader.ReadString('\n')
		email = strings.ReplaceAll(strings.ReplaceAll(email, "\n", ""), "\r", "")
		fmt.Print("Token: ")
		token, _ := reader.ReadString('\n')
		token = strings.ReplaceAll(strings.ReplaceAll(token, "\n", ""), "\r", "")

		return Register(username, email, pass, token)
	}
}

func Renew(username string, password string, token string) *FromServer {
	return DoTransaction(&ToServer{
		Username:   username,
		Password:   password,
		Data:       token,
		PacketType: "redeem",
	})
}

func Var(name string) string {
	resp := DoTransaction(&ToServer{
		Username:   ClientUsername,
		Password:   Password,
		Data:       name,
		PacketType: "var",
	})
	if resp != nil {
		return resp.Data
	}
	return ""
}

func AVar() map[string]string {
	resp := DoTransaction(&ToServer{
		Username:   ClientUsername,
		Password:   Password,
		PacketType: "avar",
	})

	if resp != nil {
		return resp.ArrData
	}
	return nil
}

func RenewCMD() *FromServer {
	for {
		reader := bufio.NewReader(os.Stdin)
		fmt.Print("Username: ")
		username, _ := reader.ReadString('\n')
		username = strings.ReplaceAll(strings.ReplaceAll(username, "\n", ""), "\r", "")
		fmt.Print("Password: ")
		passwd, _ := terminal.ReadPassword(int(syscall.Stdin))
		pass := strings.ReplaceAll(strings.ReplaceAll(string(passwd), "\n", ""), "\r", "")
		fmt.Println()
		fmt.Print("Token: ")
		token, _ := reader.ReadString('\n')
		token = strings.ReplaceAll(strings.ReplaceAll(token, "\n", ""), "\r", "")

		return Renew(username, pass, token)
	}
}

func Heartbeat() bool {
	ts := &ToServer{
		Data: "1.5",
		PacketType: "heartbeat",
	}

	resp := DoTransaction(ts)
	//	fmt.Println("resp", resp)
	if resp.Status == "failure" {
		utils.LogError("Somethings fishy...")
		return false
	}

	if resp.Message == "update_available" {
		err := browser.OpenURL(resp.Data)
		if err != nil {
			utils.LogError("Failed to open browser")
			utils.LogInfo("Url for updated file: " + resp.Data)
		}
		return false
	}
	return true
}