package ui

import (
	"fmt"
	"git.quartzinc.dev/xiQQQ/ProbemasKeker/shared"
	"github.com/gdamore/tcell"
	"github.com/rivo/tview"
	"time"
)

var (
	App *tview.Application

	MainMenu *tview.Grid
	StatusMenu *tview.Grid
	ProxyMenu *tview.Grid
	Pages *tview.Pages

	Settings *tview.Form
	Options *tview.List
	Warning *tview.Modal
	Cancel *tview.TextView
)


func CreateUI() {
	App = tview.NewApplication()
	Pages = tview.NewPages()

	Warning = tview.NewModal()
	Warning.SetTitleAlign(tview.AlignCenter).SetBorder(true)

	Cancel = tview.NewTextView()
	Cancel.SetText("PRESS [ESC] TO CANCEL").SetTextColor(tcell.ColorYellow)
	Cancel.SetBorderPadding(1,0,44,0)

	//HitCurrentCell = 0

	CreateSettings()
	CreateStats()
	CreateProxyTable()
	CreateHitsTable()
	CreateOptions()
	CreatePages()

}

func StartUI() error{
	go func() {
		for {

			App.QueueUpdateDraw(func() {

				StatusMenu.Box.SetTitle(fmt.Sprintf(" Running [%s] ", shared.FmtDuration(time.Now().Sub(startTime)))).SetTitleAlign(1).SetBorder(true)
				ProxyMenu.Box.SetTitle(fmt.Sprintf(" Running [%s] ", shared.FmtDuration(time.Now().Sub(startTime)))).SetTitleAlign(1).SetBorder(true)

				ProxyTable.SetCell(1,0,tview.NewTableCell(fmt.Sprintf("%s", proxyType)).SetAlign(tview.AlignCenter).SetMaxWidth(15)).
					SetCell(1,1,tview.NewTableCell(fmt.Sprintf("%d", proxiesLen)).SetAlign(tview.AlignCenter).SetMaxWidth(15)).
					SetCell(1,2,tview.NewTableCell(fmt.Sprintf("%d", PAlive)).SetAlign(tview.AlignCenter).SetMaxWidth(15)).
					SetCell(1,3,tview.NewTableCell(fmt.Sprintf("%d / %d",PChecked, proxiesLen)).SetAlign(tview.AlignCenter).SetMaxWidth(15))

				StatsTable.SetCell(1,0,tview.NewTableCell(fmt.Sprintf("%d", CPM.Rate())).SetAlign(tview.AlignCenter)).
					SetCell(1,1,tview.NewTableCell(fmt.Sprintf("%d", Hits )).SetAlign(tview.AlignCenter)).
					SetCell(1,2,tview.NewTableCell(fmt.Sprintf("%d", Bads)).SetAlign(tview.AlignCenter)).
					SetCell(1,3,tview.NewTableCell(fmt.Sprintf("%d", ReqErr )).SetAlign(tview.AlignCenter)).
					SetCell(1,4, tview.NewTableCell(fmt.Sprintf("%d / %d", Checked, combosLen)).SetAlign(tview.AlignCenter))

			})
			time.Sleep(500 * time.Millisecond)
		}
	}()

	return App.SetRoot(Pages, true).Run()
}




