package ui

import (
	"fmt"
	"github.com/gdamore/tcell"
	"github.com/rivo/tview"
)

var(
	HitsTable 	*tview.Table
	StatsTable 	*tview.Table
	ProxyTable 	*tview.Table
)



func CreateProxyTable() {

	ProxyTable = tview.NewTable().SetBorders(true)

	ProxyTable.SetCell(0,0,tview.NewTableCell("  Proxy Type  ").SetAlign(tview.AlignCenter).SetMaxWidth(15)).
		SetCell(0,1,tview.NewTableCell("    Proxies    ").SetAlign(tview.AlignCenter).SetMaxWidth(15)).
		SetCell(0,2,tview.NewTableCell("  Proxy-Alive  ").SetAlign(tview.AlignCenter).SetMaxWidth(15)).
		SetCell(0,3,tview.NewTableCell("     Total     ").SetAlign(tview.AlignCenter).SetMaxWidth(15))

	ProxyTable.SetCell(1,0,tview.NewTableCell(fmt.Sprintf("%s", proxyType)).SetAlign(tview.AlignCenter).SetMaxWidth(15)).
		SetCell(1,1,tview.NewTableCell(fmt.Sprintf("%d", proxiesLen)).SetAlign(tview.AlignCenter).SetMaxWidth(15)).
		SetCell(1,2,tview.NewTableCell(fmt.Sprintf("%d", 0)).SetAlign(tview.AlignCenter).SetMaxWidth(15)).
		SetCell(1,3,tview.NewTableCell(fmt.Sprintf("%d / %d",0, proxiesLen)).SetAlign(tview.AlignCenter).SetMaxWidth(15))

	ProxyTable.SetBorderPadding(5,0,23,0)

}

func CreateStats() {

	StatsTable = tview.NewTable().SetBorders(true)

	StatsTable.SetBorderPadding(2, 0, 15, 0)

	cols, rows := 5, 4


	for r := 1; r < rows; r++ {
		for c := 0; c < cols; c++ {
			if c == 4 && r == 1 {
				StatsTable.SetCell(r, c, tview.NewTableCell("0 / 0").SetMaxWidth(15).SetAlign(tview.AlignCenter))
			} else {
				StatsTable.SetCell(r, c, tview.NewTableCell("0").SetMaxWidth(15).SetAlign(tview.AlignCenter))
			}
		}
	}

	StatsTable.
		SetCell(0, 0, tview.NewTableCell("      CPM      ").SetTextColor(tcell.ColorFireBrick).SetMaxWidth(15)).
		SetCell(0, 1, tview.NewTableCell("     Hits      ").SetTextColor(tcell.ColorLime).SetMaxWidth(15)).
		SetCell(0, 2, tview.NewTableCell("     Bads      ").SetTextColor(tcell.ColorRed).SetMaxWidth(15)).
		SetCell(0, 3, tview.NewTableCell("     Error     ").SetTextColor(tcell.ColorYellow).SetMaxWidth(15)).
		SetCell(0, 4, tview.NewTableCell("     Total     ").SetTextColor(tcell.ColorMediumBlue).SetMaxWidth(15))

	StatsTable.SetCell(2, 0, tview.NewTableCell("Threads").SetAlign(tview.AlignCenter)).
		SetCell(2, 1, tview.NewTableCell("Proxy Type").SetAlign(tview.AlignCenter)).
		SetCell(2, 2, tview.NewTableCell("Combos").SetAlign(tview.AlignCenter)).
		SetCell(2, 3, tview.NewTableCell("Proxies").SetAlign(tview.AlignCenter)).
		SetCell(2, 4, tview.NewTableCell("Proxies-Alive").SetAlign(tview.AlignCenter))
}

func CreateHitsTable() {

	HitsTable = tview.NewTable()

	HitsTable.SetBorderPadding(2, 0, 30, 0)

	cols, rows := 3, 2

	for r := 1; r < rows; r++ {
		for c := 0; c < cols; c++ {
			switch r {
			case 0:
				HitsTable.SetCell(r, c, tview.NewTableCell("").SetTextColor(tcell.ColorRed).SetMaxWidth(15))
			case 1:
				HitsTable.SetCell(r, c, tview.NewTableCell("").SetTextColor(tcell.ColorYellow).SetMaxWidth(15).SetAlign(tview.AlignCenter))
			case 2:
				HitsTable.SetCell(r, c, tview.NewTableCell("").SetTextColor(tcell.ColorGreen).SetMaxWidth(15).SetAlign(tview.AlignCenter))
			default:
			}

		}
	}

	HitsTable.SetBorders(true).
		SetCell(0, 0, tview.NewTableCell(" Total Points  ").SetAlign(tview.AlignCenter).SetMaxWidth(16)).
		SetCell(0, 1, tview.NewTableCell(" Highest Points ").SetAlign(tview.AlignCenter).SetMaxWidth(16)).
		SetCell(0, 2, tview.NewTableCell("     Money     ").SetAlign(tview.AlignCenter).SetMaxWidth(16))

}

