package ui

import (
	"github.com/rivo/tview"
	"strconv"
)

var(
	proxyType 	string
	threads   	int
)

func CreateSettings() {

	Settings = tview.NewForm()

	Settings.SetBorder(true).SetTitle("Settings").SetTitleAlign(tview.AlignCenter)

	threadInput := tview.NewInputField().SetLabel("Threads").SetFieldWidth(6)
	proxyDropDown := tview.NewDropDown().SetLabel("ProxyType").
		AddOption("HTTP", nil).
		AddOption("SOCKS4", nil).
		AddOption("SOCKS5", nil)

	Settings.AddFormItem(proxyDropDown)
	Settings.AddFormItem(threadInput)

	Settings.AddButton("Save", func() {

		MessageWarning("Please make sure you input valid values!")

		var err error
		threads, err = strconv.Atoi(threadInput.GetText())
		_, proxyType = proxyDropDown.GetCurrentOption()

		if err != nil || proxyType == "" {
			Pages.SwitchToPage("Warning")
		} else {
			StatsTable.SetCell(3, 0, tview.NewTableCell(threadInput.GetText()).SetAlign(tview.AlignCenter))
			StatsTable.SetCell(3, 1, tview.NewTableCell(proxyType).SetAlign(tview.AlignCenter))
			Pages.SwitchToPage("Main")
		}
	}).
		AddButton("Back", func() {
			Pages.SwitchToPage("Main")
		})


}