package shared

import (
	"bufio"
	"fmt"
	"os"
	"strings"
	"time"
	. "github.com/logrusorgru/aurora"
)

func StringToFile(str string, path string) {

	_, err := os.Stat(path)

	if err != nil {
		os.Create(path)
	}

	file, err := os.OpenFile(path, os.O_APPEND|os.O_WRONLY, os.ModeAppend)
	defer file.Close()

	file.WriteString(str + "\n")
}

func SaveHits(acc string, capture string, path string){

	_, err := os.Stat(path)

	if err != nil {
		os.Create(path)
		file, _ := os.OpenFile(path, os.O_APPEND|os.O_WRONLY, os.ModeAppend)
		defer file.Close()
		file.WriteString(capture)
	}

	file, err := os.OpenFile(path, os.O_APPEND|os.O_WRONLY, os.ModeAppend)
	defer file.Close()
	file.WriteString(acc + "\n")
}

func SliceToFile(slice []string, path string) {

	file, _ := os.Create(path)

	defer file.Close()

	for _, str := range slice {
		file.WriteString(str + "\n")
	}
}

func FileToSlice(path string) []string {

	file, err := os.Open(path)
	defer file.Close()

	if err != nil {
		file, _ = os.Create(path)
	}

	//Remove blank spaces
	var slice []string
	scanner := bufio.NewScanner(file)

	for scanner.Scan() {
		if strings.TrimSpace(scanner.Text()) != "" {
			slice = append(slice, strings.TrimSpace(scanner.Text()))
		}
	}

	return slice
}


func FmtDuration(d time.Duration) string {
	d = d.Round(time.Second)
	h := d / time.Hour
	d -= h * time.Hour
	m := d / time.Minute
	d -= m * time.Minute
	s := d / time.Second
	return fmt.Sprintf("%02d:%02d:%02d", h, m, s)
}

func FileExists(filename string) bool {
	info, err := os.Stat(filename)
	if os.IsNotExist(err) {
		return false
	}
	return !info.IsDir()
}

func DirExists(filename string) bool {
	info, err := os.Stat(filename)
	if os.IsNotExist(err) {
		return false
	}
	return info.IsDir()
}

func LogInfo(msg string) {
	fmt.Printf("[%s] [%s] ~> %s\r\n", Magenta(time.Now().Format("15:04:05")), Cyan("II"), msg)
}

func GetInputStr() string {
	reader := bufio.NewReader(os.Stdin)
	opt, _ := reader.ReadString('\n')
	return strings.ReplaceAll(strings.ReplaceAll(opt, "\r", ""), "\n", "")
}