package shared

import (
	"net/http"
	"strings"
)

func Get(url string, headers map[string]string) (*http.Request, error){

	req, err := http.NewRequest("GET", url, nil)

	if err != nil {
		return nil, err
	}

	for name, value := range headers {
		req.Header.Add(name, value)
	}

	return req, nil
}

func Post(url string, data string, headers map[string]string) (*http.Request, error){

	req, err := http.NewRequest("POST", url, strings.NewReader(data))

	if err != nil{
		return nil, err
	}

	for name, value := range headers{
		req.Header.Add(name, value)
	}

	return req, nil
}