package shared

import (
	"bufio"
	"encoding/base64"
	"errors"
	"fmt"
	"h12.io/socks"
	"math/rand"
	"net/http"
	"net/url"
	"os"
	"strings"
)

type Proxy struct {
	Address string
	Type    string
	Alive   bool
	Auth    string
}

type PManager struct {
	Proxies []*Proxy
}

func SetupProxy(address string, auth string, ptype string) (*http.Transport, error) {

	err := errors.New("[WARNING] Proxy type not selected")

	if ptype == "" {
		return nil, err
	}

	var trans http.Transport

	if auth != "" {
		trans.ProxyConnectHeader = http.Header{}
		trans.ProxyConnectHeader.Add("Proxy-Authorization", "Basic "+base64.StdEncoding.EncodeToString([]byte(auth)))
	}

	switch ptype {
	case "HTTP":
		proxyUrl, _ := url.Parse(fmt.Sprintf("http://%s", address))
		trans.Proxy = http.ProxyURL(proxyUrl)
		break
	case "SOCKS4":
		dialSocksProxy := socks.Dial(fmt.Sprintf("socks4://%s?timeout=%ds", address, 10))
		trans.Dial = dialSocksProxy
		break
	case "SOCKS5":
		dialSocksProxy := socks.Dial(fmt.Sprintf("socks5://%s?timeout=%ds", address, 10))
		trans.Dial = dialSocksProxy
		break
	}

	return &trans, nil

}

func (pm *PManager) LoadProxies(path string, proxyType string) (int, error) {

	if proxyType == ""{
		return 0, errors.New("ProxyTypeNotSelected")
	}

	_, err := os.Stat("proxies.txt")

	if err != nil {
		file, _ := os.Create("proxies.txt")
		file.Close()
	}

	file, err := os.Open(path)

	if err != nil {
		return 0, err
	}

	defer file.Close()

	pm.Proxies = []*Proxy{}

	scanner := bufio.NewScanner(file)

	for scanner.Scan() {

		line := scanner.Text()
		parts := strings.Split(line, ":")

		if len(parts) == 4 {
			pm.Proxies = append(pm.Proxies, &Proxy{Address: fmt.Sprintf("%s:%s", parts[0], parts[1]), Auth: fmt.Sprintf("%s:%s", parts[2], parts[3]), Type: proxyType, Alive: false})
		} else {
			pm.Proxies = append(pm.Proxies, &Proxy{Address: line, Type: proxyType, Alive: false})
		}

	}

	return len(pm.Proxies), nil
}

func GetTest(trans *http.Transport, url string) error {

	client := &http.Client{Transport: trans}

	req, _ := http.NewRequest("GET", url, nil)

	_, err := client.Do(req)

	if err != nil {
		for i := 0; i < 3; i++ {
			_, err = client.Do(req)

			if err == nil {
				return err
			}
		}
	}

	return err
}

func GetRandomProxy() string {

	proxies := FileToSlice("proxies-living.txt")

	if len(proxies) == 0 {

		return ""

	} else if len(proxies) == 1 {

		return proxies[0]

	} else {

		return proxies[rand.Intn(len(proxies)-1)]
	}

}
