package shared

import (
	"bufio"
	"os"
	"strings"
)

type Account struct {
	creds 	string
	Hit 	bool
	Capture string
}

type ComboManager struct {
	CList []*Account
}

type Response []struct {
	Data struct {
		TokenCreate struct {
			Token string `json:"token"`
			User  struct {
				ID             string `json:"id"`
				Email          string `json:"email"`
				FullName       string `json:"fullName"`
				IsStaff        bool   `json:"isStaff"`
				IsActive       bool   `json:"isActive"`
				Is2FaEnabled   bool   `json:"is2faEnabled"`
				LoyaltyDetails struct {
					SpentPoints      float64 `json:"spentPoints"`
					Points           float64 `json:"points"`
					CurrentLevel struct {
						Name  string `json:"name"`
					} `json:"currentLevel"`
				} `json:"loyaltyDetails"`
			} `json:"user"`
		} `json:"tokenCreate"`

	} `json:"data"`
}

func (CManager *ComboManager) Load() int {

	CManager.CList = []*Account{}

	file, err := os.Open("combos.txt")
	defer file.Close()

	if err != nil {
		file, _ = os.Create("combos.txt")
	}


	scanner := bufio.NewScanner(file)

	for scanner.Scan() {
		if strings.TrimSpace(scanner.Text()) != "" {
			CManager.CList = append(CManager.CList, &Account{creds: strings.TrimSpace(scanner.Text()),})
		}
	}

	return len(CManager.CList)
}