package main

import (
	"git.quartzinc.dev/xiQQQ/ProbemasKeker/shared"
	"os"
	"git.quartzinc.dev/xiQQQ/ProbemasKeker/ui"
)

func init() {

	shared.LogInfo("Checking files")
	if !shared.FileExists("proxies.txt") {
		file, _ := os.Create("proxies.txt")
		shared.LogInfo("Creating proxies.txt")
		file.Close()
	}
	if !shared.FileExists("proxies-living.txt") {
		file, _ := os.Create("proxies-living.txt")
		shared.LogInfo("Creating proxies-living.txt")
		file.Close()
	}
	if !shared.FileExists("combos.txt") {
		file, _ := os.Create("combos.txt")
		shared.LogInfo("Creating combos.txt")
		file.Close()
	}
	if !shared.DirExists("results") {
		shared.LogInfo("Creating results folder")
		_ = os.Mkdir("results", 0755)
	}
}

func main() {

	ui.CreateUI()

	if err := ui.StartUI(); err != nil{
		panic(err)
	}
}