using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net.Sockets;
using System.Security.Cryptography;
using System.Text;
using System.Windows.Forms;

namespace QuartzAuth
{
    internal class Uplink
    {

        public static string ENCRYPT_KEY { get; set; }
        public static string ENCRYPT_SALT { get; set; }

        internal static string user;
        internal static string pass;

        internal static string version = "1.1";

        public static bool online { get; set; }

        public static void HeartBeat()
        {
            Start_Session();
            ToServer cmd = new ToServer();
            cmd.packettype = "heartbeat";
            cmd.key = Auth.Secret;
            cmd.version = Auth.Version;
            cmd.hash = Auth.Hash;
            cmd.hwid = Security.Fingerprint();
            cmd.data = version;
            var resp = DoTransaction(cmd);
            if (resp.message == "dll_update")
            {
                MessageBox.Show("Update!", "QALib Update available.", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                Process.Start(resp.data);
            }

            if (resp.status == "success")
                online = true;
            if (resp.message == "invalid hash")
            {
                Process.GetCurrentProcess().Close();
            }
            if (resp.message == "update_available")
            {
                Process.Start(resp.data);
                Process.GetCurrentProcess().Close();
            }
        }

        public static FromServer authenticate(string username, string password)
        {
            Start_Session();
            var cmd = new ToServer();
            cmd.username = user = username;
            cmd.password = pass = password;
            cmd.key = Auth.Secret;
            cmd.packettype = "authenticate";
            cmd.hwid = Security.Fingerprint();
            cmd.hash = Auth.Hash;
            cmd.version = Auth.Version;
            var resp = DoTransaction(cmd);
            UserInfo.Expiry = Convert.ToDateTime(resp.expiry);
            UserInfo.Level = resp.level;
            UserInfo.Username = username;
            return resp;
        }

        public static FromServer register(string username, string password, string email, string token)
        {
            Start_Session();
            var cmd = new ToServer();
            cmd.username = username;
            cmd.password = password;
            cmd.hwid = Security.Fingerprint();
            cmd.hash = Auth.Hash;
            cmd.email = email;
            cmd.data = token;
            cmd.version = Auth.Version;
            cmd.key = Auth.Secret;
            cmd.packettype = "register";
            return DoTransaction(cmd);
        }

        public static FromServer renew(string username, string password, string token)
        {
            Start_Session();
            var cmd = new ToServer();
            cmd.username = username;
            cmd.password = password;
            cmd.hwid = Security.Fingerprint();
            cmd.hash = Auth.Hash;
            cmd.data = token;
            cmd.key = Auth.Secret;
            cmd.version = Auth.Version;
            cmd.packettype = "redeem";
            return DoTransaction(cmd);
        }

        public static FromServer variables(string name)
        {
            Start_Session();
            var cmd = new ToServer();
            cmd.username = user;
            cmd.password = pass;
            cmd.data = name;
            cmd.hash = Auth.Hash;
            cmd.hwid = Security.Fingerprint();
            cmd.key = Auth.Secret;
            cmd.version = Auth.Version;
            cmd.packettype = "var";
            return DoTransaction(cmd);
        }

        private static FromServer DoTransaction(ToServer cmd)
        {
            var enc = ENCRYPT_KEY;
            var salt = ENCRYPT_SALT;
            FromServer obj = new FromServer();
            var host = "37.228.132.179";
            var port = 3333;
            try
            {
                using (var client = new TcpClient(host, port))
                using (var stream = client.GetStream())
                {
                    online = true;
                    var a = Encoding.UTF8.GetBytes(Encrypt(cmd, enc, salt));
                    stream.Write(a, 0, a.Length);
                    client.Client.Shutdown(SocketShutdown.Send);
                    byte[] resp = new byte[1024];
                    int read = stream.Read(resp, 0, resp.Length);
                    if (read > 0)
                    {
                        obj = Decrypt(Encoding.UTF8.GetString(resp), enc, salt);
                    }
                }
            }
            catch
            {
                online = false;
            }
            return obj;
        }

        private static string Encrypt(ToServer cmd, string enc, string salt)
        {
            AES256 aes = new AES256();
            JObject oj = new JObject();
            oj.Add("username", aes.EncryptWithSalt(cmd.username, enc, salt));
            oj.Add("password", aes.EncryptWithSalt(cmd.password, enc, salt));
            oj.Add("email", aes.EncryptWithSalt(cmd.email, enc, salt));
            oj.Add("hwid", aes.EncryptWithSalt(cmd.hwid, enc, salt));
            oj.Add("hash", aes.EncryptWithSalt(cmd.hash, enc, salt));
            oj.Add("data", aes.EncryptWithSalt(cmd.data, enc, salt));
            oj.Add("key", aes.EncryptWithSalt(cmd.key, enc, salt));
            oj.Add("version", aes.EncryptWithSalt(cmd.version, enc, salt));
            oj.Add("packettype", aes.EncryptWithSalt(cmd.packettype, enc, salt));
            oj.Add("session_id", enc);
            oj.Add("salt", salt);

            var payload = aes.Encrypt(oj.ToString(), "zLy&CyLg#tvUp4aH6tDH7F%fx=w6xCa%r_A^3hkq468nuuc5=7xba^un&bYLeQ=C-qL_hp#rnNU5a!5neb%_&aygXDL8Jg7?Y6cHpLAtEXM&kbfGTzyQm3Lv");
            return payload;
        }
        private static FromServer Decrypt(string str, string enc, string salt)
        {
            AES256 aes = new AES256();
            var payload = aes.Decrypt(str, "zLy&CyLg#tvUp4aH6tDH7F%fx=w6xCa%r_A^3hkq468nuuc5=7xba^un&bYLeQ=C-qL_hp#rnNU5a!5neb%_&aygXDL8Jg7?Y6cHpLAtEXM&kbfGTzyQm3Lv");
            //Console.WriteLine(payload);

            FromServer fs = new FromServer();
            JObject o = JObject.Parse(payload);
            fs.status = aes.DecryptWithSalt(o["status"].ToString(), enc, salt);
            fs.message = aes.DecryptWithSalt(o["message"].ToString(), enc, salt);
            fs.data = aes.DecryptWithSalt(o["data"].ToString(), enc, salt);
            fs.expiry = o["expiry"].ToString();
            fs.level = Int32.Parse(o["level"].ToString());

            return fs;
        }

        public static string GetUniqueToken(int length, string chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-_")
        {
            using (RNGCryptoServiceProvider crypto = new RNGCryptoServiceProvider())
            {
                byte[] data = new byte[length];

                // If chars.Length isn't a power of 2 then there is a bias if we simply use the modulus operator. The first characters of chars will be more probable than the last ones.
                // buffer used if we encounter an unusable random byte. We will regenerate it in this buffer
                byte[] buffer = null;

                // Maximum random number that can be used without introducing a bias
                int maxRandom = byte.MaxValue - ((byte.MaxValue + 1) % chars.Length);

                crypto.GetBytes(data);

                char[] result = new char[length];

                for (int i = 0; i < length; i++)
                {
                    byte value = data[i];

                    while (value > maxRandom)
                    {
                        if (buffer == null)
                        {
                            buffer = new byte[1];
                        }

                        crypto.GetBytes(buffer);
                        value = buffer[0];
                    }

                    result[i] = chars[value % chars.Length];
                }

                return new string(result);
            }
        }


        public static void Start_Session()
        {
            ENCRYPT_KEY = GetUniqueToken(32);
            ENCRYPT_SALT = GetUniqueToken(16);
        }

        public class ToServer
        {
            public string username { get; set; }
            public string password { get; set; }
            public string email { get; set; }
            public string hwid { get; set; }
            public int level { get; set; }
            public string packettype { get; set; }
            public string hash { get; set; }
            public string data { get; set; }
            public string key { get; set; }
            public string version { get; set; }
            public string session_id { get; set; }
            public string salt { get; set; }
        }

        public class FromServer
        {
            public string status { get; set; }
            public string message { get; set; }
            public string data { get; set; }
            public string expiry { get; set; }
            public int level { get; set; }
        }
    }
}
