using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace QuartzAuth
{
    public class Auth
    {
        public static string Secret { get; set; }
        public static string VSecret { get; set; }
        public static string Version { get; set; }
        public static string Hash { get; set; }
        private WebClient webClient = null;

        public static void Init(string ProgramKey, string VariableKey, string Ver)
        {
            Secret = ProgramKey;
            VSecret = VariableKey;
            Version = Ver;
            Hash = Security.CalculateMD5(Assembly.GetEntryAssembly().Location);
            Security.Fingerprint();
            Uplink.HeartBeat();
        }

        public static bool Login(string username, string password)
        {
            var resp = Uplink.authenticate(username, password);
            if (resp.status != "success")
            {
                MessageBox.Show(resp.message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            return true;
        }

        public static bool Register(string username, string password, string email, string token)
        {
            var resp = Uplink.register(username, password, email, token);
            if (resp.status != "success")
            {
                MessageBox.Show(resp.message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            return true;
        }

        public static bool Renew(string username, string password, string token)
        {
            var resp = Uplink.renew(username, password, token);
            if (resp.status != "success")
            {
                MessageBox.Show(resp.message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            return true;
        }

        public static string Var(string name)
        {
            var resp = Uplink.variables(name);
            if (resp.status != "success")
            {
                MessageBox.Show(resp.message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return null;
            }
            return resp.data;
        }

        public static void Update(string url) {
            webClient = new WebClient();
            webClient.DownloadFileCompleted += new AsyncCompletedEventHandler(DownloadCompleted); 
            webClient.DownloadFileAsync(new Uri(url), GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + @"\update.zip");
        }
        
        private void DownloadCompleted(object sender, AsyncCompletedEventArgs e) {
            webClient = null;
            GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + @"\update.zip";
            System.IO.Compression.ZipFile.ExtractToDirectory(zipPath, GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location));
        }
    }
}
