package main

import (
	"database/sql"
	"errors"
	"fmt"
	"golang.org/x/crypto/bcrypt"
	"log"
	"crypto/hmac"
	"crypto/sha512"
	"encoding/hex"
	"github.com/AvraamMavridis/randomcolor"
	"github.com/bwmarrin/discordgo"
	"math/rand"
	"strconv"
	"strings"
	"time"
	ps "github.com/mitchellh/go-ps"
)

func GenError(message string) *ToClient {
	return &ToClient{
		Status:  "error",
		Message: message,
	}
}

func hashAndSalt(pwd []byte) string {

	// Use GenerateFromPassword to hash & salt pwd.
	// MinCost is just an integer constant provided by the bcrypt
	// package along with DefaultCost & MaxCost.
	// The cost can be any value you want provided it isn't lower
	// than the MinCost (4)
	hash, err := bcrypt.GenerateFromPassword(pwd, 14)
	if err != nil {
		log.Println(err)
	}    // GenerateFromPassword returns a byte slice so we need to
	// convert the bytes to a string and return it
	return string(hash)
}

func getToken(token string, program int) (*Token, error) {
	t := &Token{Token: token, ProgramID: program}
	stmt, err := DatabaseConnection.Prepare("SELECT level, days, used FROM tokens WHERE token = ? AND program_id = ?")
	if err != nil {
		fmt.Println(err.Error())
		return nil, errors.New("database_error")
	}
	row := stmt.QueryRow(token, program)
	switch err := row.Scan(&t.Level, &t.Days, &t.Used); err {
	case sql.ErrNoRows:
		fmt.Println("not exist")
		return nil, errors.New("invalid_token")
	case nil:
		if t.Used == 1 {
			return nil, errors.New("invalid_token")
		}
		return t, nil
	default:
		panic(err)
	}
}

func getProgram(key string) (*Program, error) {
	p := &Program{Key:key}
	stmt, err := DatabaseConnection.Prepare("SELECT id, name, hash, varkey, enabled, devmode, url, version FROM programs WHERE `key` = ?")
	if err != nil {
		fmt.Println("stmt error", err.Error())
		return nil, errors.New("database_error")
	}
	row := stmt.QueryRow(p.Key)
	switch err := row.Scan(&p.Id, &p.Name, &p.Hash, &p.VarKey, &p.Enabled, &p.Devmode, &p.Url, &p.Version); err {
	case sql.ErrNoRows:
		return nil, errors.New("invalid_program")
	case nil:
		return p, nil
	default:
		panic(err)
	}
}

func getProgramByOwnerID(id int) (*Program, error) {
	p := &Program{OwnerID: id}
	stmt, err := DatabaseConnection.Prepare("SELECT name, hash, key, varkey, enabled, devmode, url, version FROM programs WHERE `owner_id` = ?")
	if err != nil {
		fmt.Println("stmt error", err.Error())
		return nil, errors.New("database_error")
	}
	row := stmt.QueryRow(id)
	switch err := row.Scan(&p.Name, &p.Hash, &p.Key, &p.VarKey, &p.Enabled, &p.Devmode, &p.Url, &p.Version); err {
	case sql.ErrNoRows:
		return nil, errors.New("invalid_program")
	case nil:
		return p, nil
	default:
		panic(err)
	}
}

func getUser(username string, program int) (*UserAccount, error) {
	ua := &UserAccount{Username: username, ProgramID: program}
	stmt, err := DatabaseConnection.Prepare("SELECT id, password, email, hwid, level, expires FROM program_users WHERE username = ? AND program_id = ?")
	if err != nil {
		fmt.Println(err.Error())
		return nil, errors.New("database_error")
	}
	row := stmt.QueryRow(username, program)
	switch err := row.Scan(&ua.Id, &ua.Password, &ua.Email, &ua.HWID, &ua.Level, &ua.Expires); err {
	case sql.ErrNoRows:
		return nil, errors.New("invalid_user")
	case nil:
	fmt.Println("pid", ua.ProgramID)
		return ua, nil
	default:
		panic(err)
	}
}

func FmtDuration(d time.Duration) string {
	d = d.Round(time.Second)
	h := d / time.Hour
	d -= h * time.Hour
	m := d / time.Minute
	d -= m * time.Minute
	s := d / time.Second
	return fmt.Sprintf("%02d:%02d:%02d", h, m, s)
}

type Field struct {
	name string
	value string
}

func SendError(s *discordgo.Session, m* discordgo.MessageCreate, message string) {
	emb := NewEmbed().
		SetTitle("ERROR!").
		SetDescription(message).
		SetColor(0xff0000)
	s.ChannelMessageSendEmbed(m.ChannelID, emb.MessageEmbed)
}

func ArrayContains(arr []string, str string) bool {
	for _, k := range arr {
		if k == str {
			return true
		}
	}
	return false
}

func ArrayReverse(a []string) []string {
	b := a
	for i := len(b)/2-1; i >= 0; i-- {
		opp := len(b)-1-i
		b[i], b[opp] = b[opp], b[i]
	}
	return b
}

func UserHasRole(s *discordgo.Session, m *discordgo.MessageCreate, roleIDInput string) bool {
	member, err := s.State.Member(m.GuildID, m.Author.ID)
	if err != nil {
		if member, err = s.GuildMember(m.GuildID, m.Author.ID); err != nil {
			SendError(s,m, "errr.")
			return false
		}
	}
	for _, roleID := range member.Roles {
		if roleID == roleIDInput {
			return true
		}
	}
	return false
}

func ComputeHmac256(message []byte, secret []byte) string {
	hash := hmac.New(sha512.New, secret)
	hash.Write(message)

	// to lowercase hexits
	return hex.EncodeToString(hash.Sum(nil))

	//return base64.StdEncoding.EncodeToString(hash.Sum(nil))
}

func SelfDestructingMessage(s *discordgo.Session, m *discordgo.MessageCreate, title string, message string, secondsToDeath int) {
	emb := NewEmbed().SetTitle(title).SetDescription(message).SetColor(0xff9333)
	err := s.ChannelMessageDelete(m.ChannelID, m.ID)
	if err != nil {
		fmt.Println(err.Error())
	}
	msg, err := s.ChannelMessageSendEmbed(m.ChannelID, emb.MessageEmbed)
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	for i:=secondsToDeath; i>0; i-- {
		emb.SetFooter(fmt.Sprintf("Seconds to self destruct: %d", i))
		msg, _ = s.ChannelMessageEditEmbed(msg.ChannelID, msg.ID, emb.MessageEmbed)
		delaySecond(1)
	}
	s.ChannelMessageDelete(msg.ChannelID, msg.ID)
}

func delaySecond(n time.Duration) {
	time.Sleep(n * time.Second)
}

const letterBytes = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
const (
	letterIdxBits = 6                    // 6 bits to represent a letter index
	letterIdxMask = 1<<letterIdxBits - 1 // All 1-bits, as many as letterIdxBits
	letterIdxMax  = 63 / letterIdxBits   // # of letter indices fitting in 63 bits
)

func RandStringBytesMaskImprSrc(n int) string {
	src := rand.NewSource(time.Now().UnixNano())
	b := make([]byte, n)
	// A src.Int63() generates 63 random bits, enough for letterIdxMax characters!
	for i, cache, remain := n-1, src.Int63(), letterIdxMax; i >= 0; {
		if remain == 0 {
			cache, remain = src.Int63(), letterIdxMax
		}
		if idx := int(cache & letterIdxMask); idx < len(letterBytes) {
			b[i] = letterBytes[idx]
			i--
		}
		cache >>= letterIdxBits
		remain--
	}

	return string(b)
}

func FooterTimestamp() string {
	return fmt.Sprintf("%s", time.Now().Format("Mon Jan 2 15:04:05"))
}

func RandomColor() int {
	color, err := strconv.ParseInt(strings.ReplaceAll(randomcolor.GetRandomColorInHex(), "#", ""), 16, 64)
	if err != nil {
		fmt.Println(err.Error())
		return 0
	}
	return int(color)
}

func GetFrontendLinkUser(id string) int {
	stmt, err := DatabaseConnection.Prepare("SELECT user_id FROM discord_link WHERE discord_id = ?")
	if err != nil {
		return -1
	}
	var user_id int
	
	row := stmt.QueryRow(id)
	switch err := row.Scan(&user_id); err {
	case sql.ErrNoRows:
		return 0
	case nil:
		return user_id
	default:
		panic(err)
	}
}

func GetProgramsByUser(id int) []*Program {
	stmt, err := DatabaseConnection.Prepare("SELECT program_id, access FROM program_admins WHERE user_id = ?")
	if err != nil {
		fmt.Println("stmt error", err.Error())
		return nil
	}

	rows, err := stmt.Query(id)
	if err != nil {
		fmt.Println(err.Error())
		return nil
	}

	var ors string
	ids := make(map[int]int)

	for rows.Next() {
		var ii int
		var access int
		err = rows.Scan(&ii, &access)
		if err != nil {
			fmt.Println(err.Error())
			continue
		}
		ids[ii] = access
		ors += fmt.Sprintf(" OR id = %d", ii)
	}

	stmt, err = DatabaseConnection.Prepare("SELECT id, name, hash, `key`, varkey, enabled, devmode, url, version FROM programs WHERE `owner_id` = ?" + ors)
	if err != nil {
		fmt.Println("stmt error", err.Error())
		return nil
	}

	var arr []*Program
	rows, err = stmt.Query(id)
	if err != nil {
		fmt.Println(err.Error())
		return nil
	}
	
	for rows.Next() {
		p := &Program{}
		err = rows.Scan(&p.Id, &p.Name, &p.Hash, &p.Key, &p.VarKey, &p.Enabled, &p.Devmode, &p.Url, &p.Version)
		if err != nil {
			fmt.Println(err.Error())
			continue
		}
		acc := ids[p.Id]
		if acc != 0 {
			p.Access = acc
		} else {
			p.Access = 3
		}
		arr = append(arr, p)
	}

	return arr
}

func GetProgramByUserAndID(progid int, id int) *Program {
	programs := GetProgramsByUser(id)
	
	for _,k := range programs {
		if k.Id == progid {
			return k
		}
	}
	return nil
	/*stmt, err := DatabaseConnection.Prepare("SELECT id, name, hash, `key`, varkey, enabled, devmode, url, version FROM programs WHERE `owner_id` = ? AND id = ?")
	if err != nil {
		fmt.Println("stmt error", err.Error())
		return nil
	}
	
	p := &Program{}
	row := stmt.QueryRow(id, progid)
	if err != nil {
		fmt.Println(err.Error())
		return nil
	}
	switch err := row.Scan(&p.Id, &p.Name, &p.Hash, &p.Key, &p.VarKey, &p.Enabled, &p.Devmode, &p.Url, &p.Version); err {
	case sql.ErrNoRows:
		return nil
	case nil:
		return p
	default:
		panic(err)
	}*/
}

func ComesFromDM(s *discordgo.Session, m *discordgo.MessageCreate) (bool, error) {
	channel, err := s.State.Channel(m.ChannelID)
	if err != nil {
		if channel, err = s.Channel(m.ChannelID); err != nil {
			return false, err
		}
	}

	return channel.Type == discordgo.ChannelTypeDM, nil
}

func CreationTime(ID string) (t time.Time, err error) {
	i, err := strconv.ParseInt(ID, 10, 64)
	if err != nil {
		return
	}
	timestamp := (i >> 22) + 1420070400000
	t = time.Unix(timestamp/1000, 0)
	return
}

func FindProcess(name string) bool {
	procs, err := ps.Processes()
	if err != nil {
		fmt.Println(err.Error())
		return false
	}
	for _,k := range procs {
		if k.Executable() == name {
			return true
		}
	}
	return false
}