package main

import (
	"fmt"
	"github.com/bwmarrin/discordgo"
	"log"
	"strings"
	"time"
	_ "github.com/go-sql-driver/mysql"
	"database/sql"
	"os"
	"os/signal"
	"syscall"
)

const (
	TOKEN = "NjQ5MjcyMjE4NjIyMDk5NDYx.Xd7V3g.E7_lj48eRCpjINN_GXp4DDcSf-c"
	VERSION = "1.0"
	CMD_PREFIX = "~!"
)

var (
	BotObject 	*discordgo.Session
	BotUser		*discordgo.User
	CmdList 	*CommandList
	DatabaseConnection *sql.DB
)

func init() {
	CmdList = new(CommandList)
	fmt.Println("Adding discord bot commands")
	CmdList.NewCommand("help", []string{"help", "?"}, "Shows this help message", "help [cmd]", 0, discordgo.PermissionSendMessages, []string{"cmd"}, HelpCommand)
	CmdList.NewCommand("usage", []string{"usage", "u"}, "Shows command usage", "usage [cmd]", 0, discordgo.PermissionSendMessages, []string{"cmd"}, UsageCommand)
	CmdList.NewCommand("ping", []string{"ping", "p"}, "Pings the bot", "ping", 0, discordgo.PermissionSendMessages, []string{}, PingCommand)
	CmdList.NewCommand("programs", []string{"programs", "lp"}, "Lists your QuartzAuth applications", "programs", 0, discordgo.PermissionSendMessages, []string{}, ListProgramsCommand)
	CmdList.NewCommand("tokens", []string{"tokens", "gt"}, "Generate tokens for your account", "tokens {program id} [amount=1] [level=1] [length 1=1day 2=3day 3=1week 4=1month 5=3month 6=1year 7=lifetime]", 1, discordgo.PermissionSendMessages, []string{"programid", "amount", "level", "length"}, GenTokensCommand)
	CmdList.NewCommand("hwid", []string{"hwid", "hw"}, "Reset a users HWID", "hwid {program id} {username/email}", 2, discordgo.PermissionSendMessages, []string{"programid", "identifier"}, ResetHWIDCommand)
	CmdList.NewCommand("link", []string{"link", "l"}, "Get a link to invite me", "link", 0, discordgo.PermissionSendMessages, []string{}, LinkCommand)
	CmdList.NewCommand("quartz", []string{"quartz", "q"}, "Get a link to QuartzInc. server", "quartz", 0, discordgo.PermissionSendMessages, []string{}, QuartzServerCommand)
	CmdList.NewCommand("status", []string{"status", "s"}, "Show status of QuartzAuth", "status", 0, discordgo.PermissionSendMessages, []string{}, StatusCommand)
	CmdList.NewCommand("download", []string{"download", "dl"}, "Get the link to download your programs latest version", "download {id}", 1, discordgo.PermissionSendMessages, []string{"programid"}, GetDownloadCommand)
	CmdList.NewCommand("license", []string{"license", "lu"}, "Update Licenses by increasing time", "license {id} {1 day}", 2, discordgo.PermissionSendMessages, []string{"programid", "timevalue"}, IncreaseLicenses)
	CmdList.NewCommand("set", []string{"set"}, "Set license expiry time", "set {id} {username} {YYYY-MM-DD}", 3, discordgo.PermissionSendMessages, []string{"programid", "username", "expiry"}, SetLicenses)
}

func main() {
	DatabaseConnection = CreateCon()
	defer DatabaseConnection.Close()

	go WebServerStartup()
	
	BotObject, err := discordgo.New("Bot " + TOKEN)
	if err != nil {
		log.Fatal("Error opening Discord Session")
	}
	defer BotObject.Close()
	BotUser, err = BotObject.User("@me")
	if err != nil {
		log.Fatal("Error getting bot user")
	}

	BotObject.AddHandler(commandHandler)
	BotObject.AddHandler(func(d *discordgo.Session, ready *discordgo.Ready) {
		fmt.Println("Bot Started, running on", len(d.State.Guilds), "servers")
		go func(d *discordgo.Session, ready *discordgo.Ready) {
			for {
				err = BotObject.UpdateStatus(0, fmt.Sprintf("QuartzAuth %s | DLL %s", VERSION, "1.4"))
				time.Sleep(25 * time.Second)
			}
		}(d,ready)
	})

	err = BotObject.Open()
	if err != nil {
		log.Fatal("error opening connection,", err)
	}
	log.Printf("Now running. Press CTRL-C to exit.")
	sc := make(chan os.Signal, 1)
	signal.Notify(sc, syscall.SIGINT, syscall.SIGTERM, os.Interrupt, os.Kill)
	<-sc
}

func CreateCon() *sql.DB {
	db, err := sql.Open("mysql", "qauth:fA7FanTBZk^cHLf8@tcp(127.0.0.1:3306)/quartzauth?parseTime=true")
	if err != nil {
		fmt.Println(err.Error())
		return nil
	} else {
		fmt.Println("db is connected")
	}
	//defer db.Close()
	// make sure connection is available
	err = db.Ping()
	fmt.Println(err)
	if err != nil {
		fmt.Println("MySQL db is not connected")
		fmt.Println(err.Error())
	}
	return db
}

func commandHandler(s *discordgo.Session, m *discordgo.MessageCreate) {

	// Ignore all messages created by the bot itself
	// This isn't required in this specific example but it's a good practice.
	if m.Author.ID == s.State.User.ID {
		return
	}

	cmd := m.Content

	// Check for command prefix
	if strings.HasPrefix(cmd, CMD_PREFIX) {
		cmd = strings.TrimPrefix(cmd, CMD_PREFIX)
		parts := strings.Split(cmd, " ")
		cmd = parts[0]
		args := parts[1:]
		if command, ok := CmdList.Contains(cmd); ok {
			isDm, _ := ComesFromDM(s,m)
			if ok, _ := MemberHasPermission(s,m.GuildID, m.Author.ID, command.permission); ok || isDm {
				if len(args) < command.minArgs {
					go SelfDestructingMessage(s,m, "Error", "Not enough arguments, see help", 5)
				} else {
					//if command.permission != 0 {

					command.execute(s, m, args)
					//}
				}
			} else {
				go SelfDestructingMessage(s,m, "Error", "Invalid permissions", 5)
			}
		}
	}
}
