package main

import (
	"database/sql"
	"fmt"
	"time"
)

type FromClient struct {
	Username string `json:"username"`
	Password string `json:"password"`
	Email string `json:"email"`
	HWID string `json:"hwid"`
	PacketType string `json:"packettype"`
	Hash string `json:"hash"`
	Data string `json:"data"`
	Key string `json:"key"`
	VKey string `json:"vkey"`
	Version string `json:"version"`
	Session string `json:"session_id"`
	Salt string `json:"salt"`
}

type ToClient struct {
	Status string `json:"status"`
	Message string `json:"message"`
	Data string `json:"data"`
	ArrData map[string]string `json:"adata,omitempty"`
	IP string `json:"ip"`
	Expiry time.Time `json:"expiry"`
	Level int `json:"level"`
}

type Program struct {
	Id int
	Name string
	Hash sql.NullString
	Key string
	VarKey string
	Enabled int
	Devmode int
	Url sql.NullString
	Version string
	OwnerID int
	Access int
}

func (p *Program) GetUsers() []*UserAccount {
	stmt, err := DatabaseConnection.Prepare("SELECT id,username,email,hwid,expires FROM program_users WHERE program_id = ?")
	if err != nil {
    fmt.Println(err.Error())
	}
	
	rows, err := stmt.Query(p.Id)
	if err != nil {
		fmt.Println("stmt err")
	}
	
	var arr []*UserAccount
	for rows.Next() {
		ua := &UserAccount{ProgramID:p.Id}
		err = rows.Scan(&ua.Id, &ua.Username, &ua.Email, &ua.HWID, &ua.Expires)
		if err != nil {
			fmt.Println(err.Error())
			continue
		}
		arr = append(arr, ua)
	}
	return arr
}

type UserAccount struct {
	Id int
	Username string
	Password string
	Email string
	HWID string
	Level int
	Expires time.Time
	ProgramID int
}

func (ua *UserAccount) SetHWID(hwid string) {
	stmt, err := DatabaseConnection.Prepare("UPDATE program_users SET hwid = ? WHERE id = ? AND program_id = ?")
	if err != nil {
  	fmt.Println(err.Error())
		return
	}
	res, err := stmt.Exec(hwid, ua.Id, ua.ProgramID)
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	_, err = res.RowsAffected()
	if err != nil {
		fmt.Println(err.Error())
		return
	}
}

type Token struct {
	Token string
	Level int
	Days int
	Used int
	UsedBy string
	ProgramID int
}

func (t *Token) Use(user *UserAccount) *ToClient {
	stmt, err := DatabaseConnection.Prepare("UPDATE tokens SET used = 1, used_by = ? WHERE token = ? AND program_id = ?")
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	res, err := stmt.Exec(user.Id, t.Token, t.ProgramID)
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	
	_, err = res.RowsAffected()
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	
	stmt, err = DatabaseConnection.Prepare("UPDATE program_users SET expires = ? WHERE username = ? AND program_id = ?")
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database error")
	}
	user.Expires = user.Expires.AddDate(0, 0, t.Days)
	fmt.Println(user.Expires)
	_, err = stmt.Exec(user.Expires, user.Username, t.ProgramID)
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	
	return &ToClient{Status: "success", Message: "used_token"}
}

type Var struct {
	Name string
	Value string
	ProgramID int
}
