package main

import (
	"fmt"
	"time"
	"golang.org/x/crypto/bcrypt"
	"database/sql"
)

func validate(fc *FromClient) *ToClient {
	tc := &ToClient{Status: "success", Message: "alive"}
	program, err := getProgram(fc.Key)
	if err != nil {
		return GenError(err.Error())
	}

	if program.Id == 57 {
		return GenError("fuck_you :)")
	}
	
	if program.Enabled == 0 {
		return GenError("killswitch_activated")
	}
//	if program.Devmode == 1 {
//		return tc
//	}
	if fc.Version != program.Version  {
		tc = GenError("update_available")
		tc.Data = program.Url.String
		return tc
	}
	if program.Devmode == 1 {
		return tc
	}
	if !program.Hash.Valid || fc.Hash != program.Hash.String {
		return GenError("invalid_hash")
	}
	return tc
}

func heartbeat(fc *FromClient) *ToClient {
	if fc.Data != "1.5" {
		return &ToClient{Status: "success", Message: "dll_update", Data: "https://files.zertex.space/mIvMoQAc.rar"}
	}
	return &ToClient{Status: "success", Message: "alive"}
}

func login(fc *FromClient) *ToClient {
	fmt.Println(fc)
	program, err := getProgram(fc.Key)
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	fmt.Print(program,"-> ")
	if len(fc.Username) == 0 || len(fc.Password) == 0 {
		fmt.Println("invalids")
		return GenError("invalid_credentials")
	}
	
	user, err := getUser(fc.Username, program.Id)
	if err != nil {
		fmt.Println("invalid user")
		return GenError("invalid_user")
	}
	
	if res := bcrypt.CompareHashAndPassword([]byte(user.Password), []byte(fc.Password)); res != nil {
		fmt.Println(res.Error())
		return GenError("invalid_credentials")
	}
	
	if len(user.HWID) == 0 {
		user.SetHWID(fc.HWID)
	} else if fc.HWID != user.HWID {
		return GenError("invalid_hwid")
	}
	

	if user.Expires.Before(time.Now()) {
		return GenError("license_expired")
	}

	return &ToClient{
		Status:  "success",
		Message: "authenticated",
		Expiry:  user.Expires,
		Level:   user.Level,
	}
}

func register(fc *FromClient) *ToClient {
	fmt.Println(fc)
	program, err := getProgram(fc.Key)
	if err != nil {
		return GenError(err.Error())
	}
	token, err := getToken(fc.Data, program.Id)
	if err != nil {
		return GenError(err.Error())
	}

	stmt, err := DatabaseConnection.Prepare("SELECT COUNT(*) FROM program_users WHERE username=? AND program_id = ?")
	if err != nil {
		return GenError("database_error")
	}
	defer stmt.Close()
	row := stmt.QueryRow(fc.Username, program.Id)
	var c int
	err = row.Scan(&c)
	if err != nil {
		return GenError("database_error")
	}

	if c != 0 {
		return GenError("username_in_use")
	}

	stmt, err = DatabaseConnection.Prepare("INSERT INTO program_users (username, password, email, hwid, level, expires, program_id) VALUES (?, ?, ?, ?, ?, ?, ?)")
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}

	_, err = stmt.Exec(fc.Username, hashAndSalt([]byte(fc.Password)), fc.Email, fc.HWID, token.Level, time.Now().AddDate(0, 0, token.Days), program.Id)
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	
	user, err := getUser(fc.Username, program.Id)
	if err != nil {
		fmt.Println(err.Error())
		return GenError("database_error")
	}
	
	tc := token.Use(user)
	if tc.Status != "success" {
		return tc
	}

	return &ToClient{
		Status:  "success",
		Message: "registered",
	}
}

func renew(fc *FromClient) *ToClient {
	program, err := getProgram(fc.Key)
	if err != nil {
		return GenError(err.Error())
	}
	
	tc := login(fc)
	
	token, err := getToken(fc.Data, program.Id)
	if err != nil {
		return GenError(err.Error())
	}

	user, err := getUser(fc.Username, program.Id)

	if tc.Status == "success" {
		return token.Use(user)
	}
	return tc
}

func nvar(fc *FromClient) *ToClient {
	program, err := getProgram(fc.Key)
	if err != nil {
		return GenError(err.Error())
	}
	
	tc := login(fc)
	
	if tc.Status != "success" {
		return tc
	}
	
	//if fc.VKey != program.VarKey {
	//	return GenError("invalid_variable_key")
	//}
	
	stmt, err := DatabaseConnection.Prepare("SELECT `value` FROM variables WHERE program_id = ? AND name = ? LIMIT 1");
	if err != nil {
		return GenError("database error")
	}
	defer stmt.Close()
	tc = &ToClient{Status:"success"}
	
	row := stmt.QueryRow(program.Id, fc.Data)
	switch err := row.Scan(&tc.Data); err {
	case sql.ErrNoRows:
		fmt.Println("from_client", fc)
		return GenError("invalid_variable")
	case nil:
		return tc
	default:
		panic(err)
	}
}

func avar(fc *FromClient) *ToClient {
	program, err := getProgram(fc.Key)
        if err != nil {
                return GenError(err.Error())
        }
        
        tc := login(fc)
        
        if tc.Status != "success" {
                return tc
        }

	stmt, err := DatabaseConnection.Prepare("SELECT `name`,`value` FROM variables WHERE program_id = ?");
        if err != nil {
                return GenError("database error")
        }
        defer stmt.Close()
        tc = &ToClient{Status:"success"}

	rows, err := stmt.Query(program.Id)
	if err != nil {
		return GenError("database_error")
	}
	stuff := map[string]string{}

	for rows.Next() {
		var name string
		var val string
		err = rows.Scan(&name, &val)
		if err != nil {
			panic(err)
		}
		stuff[name] = val
	}
	tc.ArrData = stuff
	return tc
}
