﻿using System;
using System.Collections.Generic;
using System.IO;

namespace ZertLib
{
    public class ComboManager
    {
        private List<string> _list = new List<string>();

        public ComboManager()
        {

        }

        /// <summary>
        /// Create new ComboManager object
        /// </summary>
        /// <param name="filename">File to load combos from</param>
        public ComboManager(string filename)
        {
            LoadFromFile(filename);
        }

        /// <summary>
        /// Load combos from file
        /// </summary>
        /// <param name="filename">File to load combos from</param>
        /// <returns></returns>
        public int LoadFromFile(string filename)
        {
            try
            {
                return (_list = new List<String>(File.ReadAllLines(filename))).Count;
            } catch (Exception e)
            {
                return (_list = new List<String>()).Count;
            }
        }

        /// <summary>
        /// Gets a copy of the Combos List
        /// </summary>
        /// <returns>String list of combos</returns>
        public List<string> getList()
        {
            lock(_list)
                return new List<string>(_list);
        }

        /// <summary>
        /// Count loaded combos
        /// </summary>
        /// <returns>Combo count</returns>
        public int Count()
        {
            lock (_list)
                return _list.Count;
        }
    }

    public class Combo
    {
        public class Field
        {
            public string name;
            public string value;

            public Field() { }
            public Field(string name, string val)
            {
                this.name = name;
                this.value = val;
            }
        }

        public string Username;
        public string Password;
        public bool _checked;

        public DateTime Time = DateTime.Now;

        public List<Field> captureData = new List<Field>();

        public Combo()
        {
            
        }

        public Combo(string combo) : this(combo.Split(':')[0], combo.Split(':')[1]) { }

        public Combo(string username, string password) : base()
        {
            this.Username = username;
            this.Password = password;
        }

        public void AddCapture(string name, string value)
        {
            this.captureData.Add(new Field(name, value));
        }

        public string GetCaptureValue(string name)
        {
            return this.captureData.Find(k => k.name == name).value;
        }

        public string GetCaptureValue(int index)
        {
            return this.captureData[index].value;
        }

        public override string ToString()
        {
            string cap = "";
            foreach(var f in this.captureData)
            {
                cap += f.name + ": " + f.value + ", ";
            }
            return string.Format("{0}:{1} [ {2} ]", Username, Password, cap);
        }

    }
}
