﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Leaf.xNet;

namespace ZertLib
{
    public class CheckerManager
    {
        private string title;
        private string author = "Zertex#0001";
        private string titleFormat = "{0} | {1}/{2} | Proxies {3} | Dead {8} | Hits {4} | Bad {5} | Retries {6} | CPM {7}";
        private string[] banner;
        private List<Counter> counters = new List<Counter>();

        private List<Combo> HitList = new List<Combo>();
        private List<Combo> FailedList = new List<Combo>();
        private List<Combo> RetriesList = new List<Combo>();
        public int cpm;

        public bool IsCPMLocked = false;
        public bool TerminalUI = false;
        public bool Proxyless = false;

        private string ResultDir = string.Format("\\{0:MM-dd-yy}", DateTime.Now);

        private static int Total, Hits, Bad, Retries;

        public ComboManager cManager = new ComboManager();
        public ProxyManager pManager = new ProxyManager();
        public BotManager bManager = new BotManager();

        public ConcurrentQueue<Combo> hitsQueue = new ConcurrentQueue<Combo>();

        /// <summary>
        /// Checker Manager class, used for managing all functions of a checker
        /// </summary>
        /// <param name="title">Name of your checker</param>
        /// <param name="author">Your name</param>
        /// <param name="banner">string array with the banner data</param>
        public CheckerManager(string title, string author, string[] banner)
        {
            this.title = title;
            this.author = author;
            this.banner = banner;
            Colorful.Console.Title = string.Format(titleFormat, title, 0, 0, 0, 0, 0, 0, 0, 0);
            Task.Run(() => {
                for (; ; )
                {
                    CPM();
                    Colorful.Console.Title = string.Format(titleFormat, title, (Hits + Bad), Total, pManager.Count(), Hits, Bad, Retries, cpm, pManager.GetDead());
                    if (hitsQueue.Count > 0)
                    {
                        Combo combo;
                        if (hitsQueue.TryDequeue(out combo))
                        {
                            var output = Path.Combine("Results", ResultDir);
                            if (!Directory.Exists(output))
                                Directory.CreateDirectory(output);
                            
                        }
                    }
                    System.Threading.Thread.Sleep(500);
                }
            });
        }

        public CheckerManager()
        {
            Task.Run(() =>
            {
                for (;;)
                {
                    CPM();
                    System.Threading.Thread.Sleep(500);
                }
            });
        }

        public int CPM()
        {
            if ((Hits + Bad + Retries) == 0)
            {
                cpm = 0;
                return cpm;
            }

            if (IsCPMLocked)
            {
                return cpm;
            }

            try
            {
                var temp = 0;
                IsCPMLocked = true;
                for (int i = FailedList.Count - 1; i >= 0; i--) { if ((DateTime.Now - FailedList[i].Time).TotalSeconds > 60) break; temp++; }
                for (int i = HitList.Count - 1; i >= 0; i--) { if ((DateTime.Now - HitList[i].Time).TotalSeconds > 60) break; temp++; }
                for (int i = RetriesList.Count - 1; i >= 0; i--) { if ((DateTime.Now - RetriesList[i].Time).TotalSeconds > 60) break; temp++; }
                cpm = temp;
                IsCPMLocked = false;
            }
            catch { }
            finally { IsCPMLocked = false; }

            return cpm;
        }

        public int GetTotal()
        {
            return Total;
        }

        public int GetHits()
        {
            return Hits;
        }

        public int GetBad()
        {
            return Bad;
        }

        public int GetRetries()
        {
            return Retries;
        }

        /// <summary>
        /// Writes the banner to the screen
        /// </summary>
        /// <param name="color">Color to use</param>
        /// <param name="centered">Center the banner</param>
        public void WriteBanner(Color color, bool centered=true)
        {
            Colorful.Console.SetCursorPosition(0, 0);
            string spacer = "";
            for (int i = 0; i < (banner[0].Length/2)- (("~Checker by ~".Length+author.Length)/2); i++)
            {
                spacer += " ";
            }
            if (centered)
                spacer = "\t" + spacer;
            Colorful.Console.WriteLine("{0}~Checker by {1}~{0}", spacer, author, Color.ForestGreen);
            foreach(var part in banner)
            {
                Colorful.Console.WriteLine("\t"+part, color);
            }
        }

        /// <summary>
        /// Gets the combo file from the user
        /// </summary>
        public void GetCombos()
        {
            Colorful.Console.WriteLine("Choose combo file", Color.DeepSkyBlue);
            OpenFileDialog ofd = new OpenFileDialog();
            while (cManager.getList().Count == 0)
            {
                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    Total = cManager.LoadFromFile(ofd.FileName);
                }
            }
        }

        /// <summary>
        /// Gets the proxy file from user
        /// </summary>
        public void GetProxies(string country = "all")
        {
            int a = -1;
            while (a == -1)
            { 
                Colorful.Console.SetCursorPosition(0, this.banner.Length + 2);
                Colorful.Console.Write("[0] Auto [1] HTTP [2] SOCKS4 [3] SOCKS4a [4] SOCKS5 [5] NONE\nChoose Type [0]: ");

                var input = Console.ReadLine();
                input = input.Replace("\r", "").Replace("\n", "");
                Int32.TryParse(input, out a);
                if (a < 0 || a > 5)
                    a = -1;
            }
            pManager.SetProxyType((ProxyType)a-1);

            if (a==0)
            {
                pManager.EnterAutoMode();
                pManager.PullProxies();
            }
            else if (a==5)
            {
                this.Proxyless = true;
                pManager.SetProxyless(true);
            }
            else
            {

                Colorful.Console.WriteLine("Choose proxy file", System.Drawing.Color.DeepSkyBlue);
                OpenFileDialog ofd = new OpenFileDialog();
                while (pManager.Count() == 0)
                {
                    if (ofd.ShowDialog() == DialogResult.OK)
                    {
                        pManager.LoadFromFile(ofd.FileName, pManager.GetProxyType());
                    }
                }
            }
        }

        /// <summary>
        /// Get's number of bots from the user
        /// </summary>
        /// <param name="recommended">Default botcount to provide</param>
        public void GetBots(int recommended)
        {
            int fromTop = Colorful.Console.CursorTop;
            int a = 0;
            while (a == 0)
            {
                Colorful.Console.SetCursorPosition(0, fromTop);
                Colorful.Console.Write("Bots to use [{0} recommended]: ", recommended);

                var input = Console.ReadLine();
                input = input.Replace("\r", "").Replace("\n", "");
                if (input == "")
                    a = recommended;
                Int32.TryParse(input, out a);
                if (a < 0)
                    a = 0;
            }
            bManager.SetBotCount(a);
        }

        /// <summary>
        /// Add's a hit to the counter, displays it, and saves it to a file.
        /// </summary>
        /// <param name="c">The combo object</param>
        /// <param name="toScreen">Output hit to console, if not using counters</param>
        public void AddHit(Combo c = null, string outputDir = "")
        {
            Hits++;
            HitList.Add(new Combo());
            if (c == null)
                return;
            if (!TerminalUI)
                if (banner.Length != 0)
                    Colorful.Console.WriteLine(c.ToString(), Color.LightSeaGreen);
            var path = Path.Combine(Directory.GetCurrentDirectory(), "Output", outputDir);
            File.AppendAllText(Path.Combine(path, "output-" + DateTime.Now.Day+"-" + DateTime.Now.Month + "-" + DateTime.Now.Year + ".txt"), c.ToString()+"\r\n");
        }

        /// <summary>
        /// Increase the bad combo counter by 1
        /// </summary>
        public void AddBad()
        {
            Bad++;
            FailedList.Add(new Combo());
        }
        
        /// <summary>
        /// Add a combo back to the list of to-checks because of a proxy/connectivity error
        /// </summary>
        /// <param name="c">The combo to retry</param>
        public void AddRetry(Proxy p = null)
        {
            if (p != null)
                pManager.SetBanned(p);
            Retries++;
            RetriesList.Add(new Combo());
        }

        /// <summary>
        /// Gets the next not in use proxy
        /// </summary>
        /// <returns>Online, not in-use proxy object</returns>
        public Proxy GetNextProxy()
        {
            return pManager.GetProxy();
        }

        /// <summary>
        /// Resets the proxies, or grabs new ones if in auto mode.
        /// </summary>
        public void ResetProxies(string country = "all")
        {
            if(pManager.GetAutoMode())
            {
                pManager.PullProxies(country: country);
            } else
            {
                pManager.ResetProxies();
            }
        }

        

        /// <summary>
        /// Starts the checker
        /// </summary>
        /// <param name="checkFunc">Function for the bots to use</param>
        /// <param name="withUI">Use checker "labels" UI</param>
        public void Start(BotManager.CheckDelegate checkFunc, bool withUI = false)
        {
            Colorful.Console.Clear();
            TerminalUI = withUI;
            if (TerminalUI)
                Task.Run(() => UILoop());
            bManager.Run(checkFunc, cManager.getList().ToArray());
            Colorful.Console.WriteLine("Done Checking!", System.Drawing.Color.Green);
            Colorful.Console.ReadLine();
        }

        public void Start2(DoWorkEventHandler func, bool withUI = false)
        {
            Colorful.Console.Clear();
            TerminalUI = withUI;
            if (TerminalUI)
                Task.Run(() => UILoop());
            bManager.Run2(func, cManager.getList().ToArray());
            Colorful.Console.WriteLine("Done Checking!", System.Drawing.Color.Green);
            Colorful.Console.ReadLine();
        }

        KeyValuePair<string, int> pairs;

        /// <summary>
        /// Add a counter to be used with the terminal UI
        /// </summary>
        /// <param name="name">Name of the counter</param>
        /// <param name="color">Color of the counter</param>
        public void AddCounter(string name, Color color)
        {
            counters.Add(new Counter(name, color));
        }

        /// <summary>
        /// Increase counter by name
        /// </summary>
        /// <param name="name">Name of the counter</param>
        public void CounterIncrease(string name)
        {
            lock(counters)
            {
                counters.Find(k => k.name == name).val++;
            }
        }

        /// <summary>
        /// Loop for Terminal UI
        /// </summary>
        public void UILoop()
        {
            while(true)
            {
                Colorful.Console.Clear();
                WriteBanner(Color.Purple);
                foreach (var a in counters)
                {
                    Colorful.Console.Write("{0}", a.name, a.color);
                    Console.SetCursorPosition(50, Console.CursorTop);
                    Colorful.Console.Write("[{0}]\r\n", a.val, a.color);
                }
                System.Threading.Thread.Sleep(500);
            }
        }
        
    }

    public class Counter
    {
        public string name;
        public int val;
        public Color color;

        public Counter(string name) : this(name, Color.White)
        {
        }

        public Counter(string name, Color color)
        {
            this.name = name;
            this.color = color;
        }
    }
}
