﻿using Leaf.xNet;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ZertLib
{
    public class BotManager
    {
        private OrderablePartitioner<string> source;
        private ParallelOptions options;
        private System.Threading.CancellationTokenSource cts = new System.Threading.CancellationTokenSource();
        private Semaphore semaphore;
        private bool running;

        public delegate void CheckDelegate(string line, ParallelLoopState Breaker);


        public BotManager()
        {

        }

        public BotManager(int bots)
        {
            SetBotCount(bots);
        }

        /// <summary>
        /// Sets bots for BotManager to use
        /// </summary>
        /// <param name="bots">Amount of bots</param>
        public void SetBotCount(int bots)
        {
            options = new ParallelOptions
            {
                MaxDegreeOfParallelism = bots
            };
        }

        /// <summary>
        /// Start the botmanager to check with your function
        /// </summary>
        /// <param name="check">The function to check accounts</param>
        /// <param name="list">The list of combos, from ComboManager.getList()</param>
        public void Run(CheckDelegate check, String[] list)
        {
            cts = new CancellationTokenSource();
            options.CancellationToken = cts.Token;
            running = true;
            source = Partitioner.Create<string>(list, EnumerablePartitionerOptions.None);
            Parallel.ForEach(source, options, delegate (string line, ParallelLoopState Breaker)
            {
                try
                {
                    check(line, Breaker);
                }
                catch (Exception e) {
                    /*Console.WriteLine(e.Message);
                    Console.WriteLine(e.StackTrace);
                    Console.WriteLine(e.InnerException);*/
                }
            });
        }

        public void Run2(DoWorkEventHandler func, String[] list) {
            semaphore = new Semaphore(options.MaxDegreeOfParallelism, options.MaxDegreeOfParallelism);
            foreach(var line in list)
            {
                if (cts.IsCancellationRequested)
                    return;
                semaphore.WaitOne();
                BackgroundWorker bw = new BackgroundWorker();
                bw.DoWork += func;
                bw.RunWorkerAsync(line);
            }

            semaphore.Dispose();
        }

        public bool IsRunning()
        {
            return running;
        }

        /// <summary>
        /// Cancels background bots and stops checking
        /// </summary>
        public void Stop()
        {
            cts.Cancel();
            running = false;
        }
    }
}
