package utils

import (
	"fmt"
	"github.com/AvraamMavridis/randomcolor"
	"math/rand"
	"strconv"
	"strings"
	"time"
)

func HexColorToInt(hexColor string) int {
	color, err := strconv.ParseInt(strings.ReplaceAll(hexColor, "#", ""), 16, 64)
	if err != nil {
		fmt.Println(err.Error())
		return 0
	}
	return int(color)
}

func RandomDelay() {
	time.Sleep(time.Duration(rand.Intn(100) + 50) * time.Millisecond)
}

func GetDiscordIDFromMention(payload string) string {
	id := strings.ReplaceAll(payload, "<@", "")
	id = strings.ReplaceAll(id, "!", "")
	return strings.ReplaceAll(id, ">", "")
}

func CreationTime(ID string) (t time.Time, err error) {
	i, err := strconv.ParseInt(ID, 10, 64)
	if err != nil {
		return
	}
	timestamp := (i >> 22) + 1420070400000
	t = time.Unix(timestamp/1000, 0)
	return
}

func RandomColor() int {
	return HexColorToInt(randomcolor.GetRandomColorInHex())
}
