package utils

import (
	"strings"
)

type L33T_ALPHABET_set []string
type L33T_ALPHABET_type []L33T_ALPHABET_set

var L33T_ALPHABET L33T_ALPHABET_type = []L33T_ALPHABET_set{
	{"a", "@"},
	{"b", "8"},
	{"c", "("},
	{"d", "<\\|"},
	{"e", "3"},
	{"f", "ph"},
	{"g", "6"},
	{"h", "\\|-\\|"},
	{"i", "1"},
	{"k", "\\|<"},
	{"l", "\\|"},
	{"m", "|\\\\/|"},
	{"n", "|\\\\|"},
	{"o", "0"},
	{"p", "\\|2"},
	// q missing
	// r missing
	{"s", "5"},
	{"t", "7"},
	{"u", "\\|_\\|"},
	{"v", "\\\\/"},
	{"v", "/"},
	{"w", "\\\\/\\\\/"},
	{"x", "><"},
	{"y", "'/"},
}

func L33T_Convert(str string) string {
	for _, element := range L33T_ALPHABET {
		var character_to_replace string = element[0]
		var replacement_string string = element[1]
		str = strings.Replace(str, character_to_replace, replacement_string, -1)
		str = strings.Replace(str, strings.ToUpper(character_to_replace), replacement_string, -1)
	}
	return str
}

func L33T_Reverse_Convert(str string) string {
	for _, element := range L33T_ALPHABET {
		var original_character string = element[0]
		var l33t_string string = element[1]
		str = strings.Replace(str, l33t_string, original_character, -1)
	}
	return str
}
