package sniper

import (
	"bytes"
	"encoding/json"
	"fmt"
	"github.com/bwmarrin/discordgo"
	"io/ioutil"
	"log"
	"net/http"
	"regexp"
	"strings"
	"time"
)

func Handler(s *discordgo.Session, m *discordgo.MessageCreate) {
	messageCreateHolder(s,m)
}
var Redeemed []string
func getTimestamp() string {
	return time.Now().Format("01-02-2006 3:4:5 PM")
}
func getTimestampW() string {
	return "[" + getTimestamp() + "]"
}
type NitroInfo struct {
	ID               string `json:"id"`
	SkuID            string `json:"sku_id"`
	ApplicationID    string `json:"application_id"`
	UserID           string `json:"user_id"`
	Type             int    `json:"type"`
	Deleted          bool   `json:"deleted"`
	Consumed         bool   `json:"consumed"`
	GifterUserID     string `json:"gifter_user_id"`
	SubscriptionPlan struct {
		ID            string `json:"id"`
		Name          string `json:"name"`
		Interval      int    `json:"interval"`
		IntervalCount int    `json:"interval_count"`
		TaxInclusive  bool   `json:"tax_inclusive"`
		SkuID         string `json:"sku_id"`
		Currency      string `json:"currency"`
		Price         int    `json:"price"`
	} `json:"subscription_plan"`
	Sku struct {
		ID             string        `json:"id"`
		Type           int           `json:"type"`
		DependentSkuID interface{}   `json:"dependent_sku_id"`
		ApplicationID  string        `json:"application_id"`
		ManifestLabels interface{}   `json:"manifest_labels"`
		AccessType     int           `json:"access_type"`
		Name           string        `json:"name"`
		Features       []interface{} `json:"features"`
		ReleaseDate    interface{}   `json:"release_date"`
		Premium        interface{}   `json:"premium"`
		Slug           string        `json:"slug"`
		Flags          int           `json:"flags"`
		ShowAgeGate    bool          `json:"show_age_gate"`
	} `json:"sku"`
}
type fetchNitroResponse struct {
	Error int
	Type  string
	Price float32
	Code  string
}

func fetchNitroInfo(code string) fetchNitroResponse {
	client := &http.Client{}
	r := "https://discordapp.com/api/v6/" + "/entitlements/gift-codes/" + code + "?with_application=false&with_subscription_plan=true"
	req, _ := http.NewRequest("POST", r, nil)
	var r2 fetchNitroResponse
	if req != nil {
		//req.Header.Add("content-type", "application/json")
		//req.Header.Add("Authorization", Token2)
		resp, err := client.Do(req)
		body, _ := ioutil.ReadAll(resp.Body)
		defer resp.Body.Close()
		var response NitroInfo
		json.Unmarshal([]byte(body), &response)
		if err != nil {
			log.Fatal(err)
			r2.Error = 2
			return r2
		}
		if strings.Contains(response.SubscriptionPlan.Name, "Classic") {
			if strings.Contains(response.SubscriptionPlan.Name, "Yearly") {
				r2.Type = "Nitro Classic Yearly"
				r2.Price = 49.99
			} else {
				r2.Type = "Nitro Classic"
				r2.Price = 4.99
			}
		} else {
			if strings.Contains(response.SubscriptionPlan.Name, "Yearly") {
				r2.Type = "Nitro Booster Yearly"
				r2.Price = 99.99
			} else if strings.Contains(response.SubscriptionPlan.Name, "Quarterly") {
				r2.Type = "Nitro Booster Quarterly"
				r2.Price = 29.97
			} else {
				r2.Type = "Nitro Booster"
				r2.Price = 9.99
			}
		}
		r2.Code = code
		r2.Error = 0
	} else {
		r2.Error = 1
		r2.Code = code
	}
	return r2
}
func redeemCode(code string, channelId string, Token2 string) {
	client := &http.Client{}
	values := map[string]string{"channel_id": channelId, "payment_source_id": "123"}
	jsonValue, _ := json.Marshal(values)
	discordRedeemURL := fmt.Sprintf("https://discordapp.com/api/v6/entitlements/gift-codes/%s/redeem", code)
	req, _ := http.NewRequest("POST", discordRedeemURL, bytes.NewBuffer(jsonValue))
	if req != nil {
		req.Header.Add("content-type", "application/json")
		req.Header.Add("Authorization", Token2)
		resp, err := client.Do(req)
		defer resp.Body.Close()
		if err != nil {
			log.Fatal(err)
		}
		var prefix = ""
		switch status := resp.StatusCode; status {
		case 200:
			{
				var nitroInfo_ = fetchNitroInfo(code)
				if nitroInfo_.Error > 0 {
					fmt.Println(getTimestampW(), "Redeemed Nitro:", code)
				} else {
					var cost = fmt.Sprintf("%f", nitroInfo_.Price)
					fmt.Println(getTimestampW(), "Redeemed", nitroInfo_.Type, "("+cost+")")
				}
			}
		case 404:
			fmt.Println(getTimestampW(), prefix, "Invalid Code:", code)
		case 400:
			fmt.Println(getTimestampW(), prefix, "Invalid Code:", code)
		}
		Redeemed = append(Redeemed, code)
	}
}

func messageCreateHolder(s *discordgo.Session, m *discordgo.MessageCreate) {
	discordGiftPattern := "(?:https?:)?discord(?:app.com/gifts/|.gift/)([^\\s]+)"
	discordGiftRegexp := regexp.MustCompile(discordGiftPattern)
	content := strings.ToLower(m.Content)
	match1 := discordGiftRegexp.MatchString(content)
	if match1 == true {
		var source string
		var channel2, _ = s.State.Channel(m.ChannelID)
		if m.GuildID == "" {
			if channel2.Type == discordgo.ChannelTypeDM {
				source = "DM Channel with " + m.Author.Username+"#"+m.Author.Discriminator
			} else if channel2.Type == discordgo.ChannelTypeGroupDM {
				if channel2.Name == "" {
					var usersA []string
					var usersS string
					for _, recepient := range channel2.Recipients {
						usersA = append(usersA, recepient.Username)
					}
					usersS = strings.Join(usersA, ", ")
					source = "Unnamed DM Group with " + usersS
				} else {
					source = "DM Group named \"" + channel2.Name + "\""
				}
			} else {
				source = "Unknown, all we know it's not a server"
			}
		} else {
			guild2, _ := s.State.Guild(m.GuildID)
			source = "Server named \"" + guild2.Name + "\" in channel #" + channel2.Name
		}
		match := discordGiftRegexp.FindStringSubmatch(content)
		//_, found := Find(Redeemed, code)
		//if !found && len(code) == 16 || len(code) == 24 {
		if len(match[1]) == 16 || len(match[1]) == 24 {
			redeemCode(match[1], m.ChannelID, s.Token)
		} else {
			fmt.Println("["+time.Now().Format("02-01-2006 3:4:5 PM")+"]", match[1], "- Already Attempted or Invalid Format | "+source)
		}
	}
}